/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.subscribers.SubscriberResourceWrapper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableReplay<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    final Publisher<T> source;
    final AtomicReference<ReplaySubscriber<T>> current;
    final Callable<? extends ReplayBuffer<T>> bufferFactory;
    final Publisher<T> onSubscribe;
    static final Callable DEFAULT_UNBOUNDED_FACTORY = new Callable(){

        public Object call() {
            return new UnboundedReplayBuffer(16);
        }
    };

    public static <U, R> Flowable<R> multicastSelector(final Callable<? extends ConnectableFlowable<U>> connectableFactory, final Function<? super Flowable<U>, ? extends Publisher<R>> selector) {
        return Flowable.unsafeCreate(new Publisher<R>(){

            @Override
            public void subscribe(Subscriber<? super R> child) {
                Publisher observable;
                ConnectableFlowable co;
                try {
                    co = (ConnectableFlowable)ObjectHelper.requireNonNull(connectableFactory.call(), "The connectableFactory returned null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    EmptySubscription.error(e, child);
                    return;
                }
                try {
                    observable = (Publisher)ObjectHelper.requireNonNull(selector.apply(co), "The selector returned a null Publisher");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    EmptySubscription.error(e, child);
                    return;
                }
                final SubscriberResourceWrapper srw = new SubscriberResourceWrapper(child);
                observable.subscribe(srw);
                co.connect((Consumer<Disposable>)new Consumer<Disposable>(){

                    @Override
                    public void accept(Disposable r) {
                        srw.setResource(r);
                    }
                });
            }
        });
    }

    public static <T> ConnectableFlowable<T> observeOn(final ConnectableFlowable<T> co, Scheduler scheduler) {
        final Flowable observable = co.observeOn(scheduler);
        return RxJavaPlugins.onAssembly(new ConnectableFlowable<T>(){

            @Override
            public void connect(Consumer<? super Disposable> connection) {
                co.connect(connection);
            }

            @Override
            protected void subscribeActual(Subscriber<? super T> s) {
                observable.subscribe(s);
            }
        });
    }

    public static <T> ConnectableFlowable<T> createFrom(Publisher<? extends T> source) {
        return FlowableReplay.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableFlowable<T> create(Publisher<T> source, final int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return FlowableReplay.createFrom(source);
        }
        return FlowableReplay.create(source, new Callable<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeBoundReplayBuffer(bufferSize);
            }
        });
    }

    public static <T> ConnectableFlowable<T> create(Publisher<T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return FlowableReplay.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableFlowable<T> create(Publisher<T> source, final long maxAge, final TimeUnit unit, final Scheduler scheduler, final int bufferSize) {
        return FlowableReplay.create(source, new Callable<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeAndTimeBoundReplayBuffer(bufferSize, maxAge, unit, scheduler);
            }
        });
    }

    static <T> ConnectableFlowable<T> create(Publisher<T> source, final Callable<? extends ReplayBuffer<T>> bufferFactory) {
        final AtomicReference<ReplaySubscriber<T>> curr = new AtomicReference<ReplaySubscriber<T>>();
        Publisher onSubscribe = new Publisher<T>(){

            @Override
            public void subscribe(Subscriber<? super T> child) {
                ReplaySubscriber<Object> r;
                while ((r = (ReplaySubscriber<Object>)curr.get()) == null) {
                    ReplayBuffer buf;
                    try {
                        buf = (ReplayBuffer)bufferFactory.call();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        throw ExceptionHelper.wrapOrThrow(ex);
                    }
                    ReplaySubscriber<Object> u = new ReplaySubscriber<Object>(buf);
                    if (!curr.compareAndSet(null, u)) continue;
                    r = u;
                    break;
                }
                InnerSubscription inner = new InnerSubscription(r, child);
                child.onSubscribe(inner);
                r.add(inner);
                if (inner.isDisposed()) {
                    r.remove(inner);
                    return;
                }
                r.manageRequests();
                r.buffer.replay(inner);
            }
        };
        return RxJavaPlugins.onAssembly(new FlowableReplay<T>(onSubscribe, source, curr, bufferFactory));
    }

    private FlowableReplay(Publisher<T> onSubscribe, Publisher<T> source, AtomicReference<ReplaySubscriber<T>> current, Callable<? extends ReplayBuffer<T>> bufferFactory) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.onSubscribe.subscribe(s);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        ReplaySubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            ReplayBuffer<T> buf;
            try {
                buf = this.bufferFactory.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw ExceptionHelper.wrapOrThrow(ex);
            }
            ReplaySubscriber<T> u = new ReplaySubscriber<T>(buf);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            if (doConnect) {
                ps.shouldConnect.compareAndSet(true, false);
            }
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAge;
        final TimeUnit unit;
        final int limit;

        SizeAndTimeBoundReplayBuffer(int limit, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAge = maxAge;
            this.unit = unit;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timed<Object>(value, this.scheduler.now(this.unit), this.unit);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timed)value).value();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e = 0;
            while (next != null) {
                if (this.size > this.limit) {
                    ++e;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                Timed v = (Timed)next.value;
                if (v.time() > timeLimit) break;
                ++e;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            Timed v;
            long timeLimit = this.scheduler.now(this.unit) - this.maxAge;
            Node prev = (Node)this.get();
            int e = 0;
            for (Node next = (Node)prev.get(); next != null && this.size > 1 && (v = (Timed)next.value).time() <= timeLimit; next = (Node)next.get()) {
                ++e;
                --this.size;
                prev = next;
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        SizeBoundReplayBuffer(int limit) {
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        Node tail;
        int size;
        long index;

        BoundedReplayBuffer() {
            Node n;
            this.tail = n = new Node(null, 0L);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            if (next == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next);
        }

        final void removeSome(int n) {
            Node head = (Node)this.get();
            while (n > 0) {
                head = (Node)head.get();
                --n;
                --this.size;
            }
            this.setFirst(head);
        }

        final void setFirst(Node n) {
            this.set(n);
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(NotificationLite.next(value));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e) {
            Object o = this.enterTransform(NotificationLite.error(e));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(NotificationLite.complete());
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerSubscription<T> output) {
            InnerSubscription<T> innerSubscription = output;
            synchronized (innerSubscription) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isDisposed()) {
                Node v;
                long r = output.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long e = 0L;
                Node node = (Node)output.index();
                if (node == null) {
                    node = (Node)this.get();
                    output.index = node;
                    BackpressureHelper.add(output.totalRequested, node.index);
                }
                while (r != 0L && (v = (Node)node.get()) != null) {
                    Object o = this.leaveTransform(v.value);
                    try {
                        if (NotificationLite.accept(o, output.child)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.index = null;
                        output.dispose();
                        if (!NotificationLite.isError(o) && !NotificationLite.isComplete(o)) {
                            output.child.onError(err);
                        }
                        return;
                    }
                    ++e;
                    --r;
                    node = v;
                    if (!output.isDisposed()) continue;
                    return;
                }
                if (e != 0L) {
                    output.index = node;
                    if (!unbounded) {
                        output.produced(e);
                    }
                }
                InnerSubscription<T> innerSubscription2 = output;
                synchronized (innerSubscription2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        void truncate() {
        }

        void truncateFinal() {
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next;
            Node n = (Node)this.get();
            while ((next = (Node)n.get()) != null && !NotificationLite.isComplete(v = this.leaveTransform(o = next.value)) && !NotificationLite.isError(v)) {
                output.add(NotificationLite.getValue(v));
                n = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;
        final long index;

        Node(Object value, long index) {
            this.value = value;
            this.index = index;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e) {
            this.add(NotificationLite.error(e));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.complete());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerSubscription<T> output) {
            InnerSubscription<T> innerSubscription = output;
            synchronized (innerSubscription) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            Subscriber child = output.child;
            while (!output.isDisposed()) {
                long r;
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                long r0 = r = output.get();
                long e = 0L;
                while (r != 0L && destinationIndex < sourceIndex) {
                    Object o = this.get(destinationIndex);
                    try {
                        if (NotificationLite.accept(o, child)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.dispose();
                        if (!NotificationLite.isError(o) && !NotificationLite.isComplete(o)) {
                            child.onError(err);
                        }
                        return;
                    }
                    if (output.isDisposed()) {
                        return;
                    }
                    ++destinationIndex;
                    --r;
                    ++e;
                }
                if (e != 0L) {
                    output.index = destinationIndex;
                    if (r0 != Long.MAX_VALUE) {
                        output.produced(e);
                    }
                }
                InnerSubscription<T> innerSubscription2 = output;
                synchronized (innerSubscription2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerSubscription<T> var1);
    }

    static final class InnerSubscription<T>
    extends AtomicLong
    implements Subscription,
    Disposable {
        private static final long serialVersionUID = -4453897557930727610L;
        final ReplaySubscriber<T> parent;
        final Subscriber<? super T> child;
        Object index;
        final AtomicLong totalRequested;
        boolean emitting;
        boolean missed;
        static final long CANCELLED = Long.MIN_VALUE;

        InnerSubscription(ReplaySubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.totalRequested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long u;
                long r;
                do {
                    if ((r = this.get()) == Long.MIN_VALUE) {
                        return;
                    }
                    if (r < 0L || n != 0L) continue;
                    return;
                } while (!this.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
                BackpressureHelper.add(this.totalRequested, n);
                this.parent.manageRequests();
                this.parent.buffer.replay(this);
                return;
            }
        }

        public long produced(long n) {
            return BackpressureHelper.producedCancel(this, n);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void cancel() {
            this.dispose();
        }

        @Override
        public void dispose() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.manageRequests();
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplaySubscriber<T>
    implements Subscriber<T>,
    Disposable {
        final ReplayBuffer<T> buffer;
        boolean done;
        static final InnerSubscription[] EMPTY = new InnerSubscription[0];
        static final InnerSubscription[] TERMINATED = new InnerSubscription[0];
        final AtomicReference<InnerSubscription<T>[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicInteger management;
        long maxChildRequested;
        long maxUpstreamRequested;
        volatile Subscription subscription;

        ReplaySubscriber(ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.management = new AtomicInteger();
            this.subscribers = new AtomicReference<InnerSubscription[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public boolean isDisposed() {
            return this.subscribers.get() == TERMINATED;
        }

        @Override
        public void dispose() {
            this.subscribers.set(TERMINATED);
            this.subscription.cancel();
        }

        boolean add(InnerSubscription<T> producer) {
            InnerSubscription[] u;
            InnerSubscription<T>[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscription[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscription<T> p) {
            InnerSubscription[] u;
            InnerSubscription<T>[] c;
            do {
                int len;
                if ((len = (c = this.subscribers.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerSubscription[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.subscribers.compareAndSet(c, u));
        }

        @Override
        public void onSubscribe(Subscription p) {
            if (SubscriptionHelper.validate(this.subscription, p)) {
                this.subscription = p;
                this.manageRequests();
                for (InnerSubscription<T> rp : this.subscribers.get()) {
                    this.buffer.replay(rp);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                for (InnerSubscription<T> rp : this.subscribers.get()) {
                    this.buffer.replay(rp);
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                this.buffer.error(e);
                for (InnerSubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    this.buffer.replay(rp);
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.buffer.complete();
                for (InnerSubscription rp : this.subscribers.getAndSet(TERMINATED)) {
                    this.buffer.replay(rp);
                }
            }
        }

        void manageRequests() {
            if (this.management.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                long ri;
                if (this.isDisposed()) {
                    return;
                }
                InnerSubscription<T>[] a = this.subscribers.get();
                long maxTotalRequests = ri = this.maxChildRequested;
                for (InnerSubscription<T> rp : a) {
                    maxTotalRequests = Math.max(maxTotalRequests, rp.totalRequested.get());
                }
                long ur = this.maxUpstreamRequested;
                Subscription p = this.subscription;
                long diff = maxTotalRequests - ri;
                if (diff != 0L) {
                    this.maxChildRequested = maxTotalRequests;
                    if (p != null) {
                        if (ur != 0L) {
                            this.maxUpstreamRequested = 0L;
                            p.request(ur + diff);
                            continue;
                        }
                        p.request(diff);
                        continue;
                    }
                    long u = ur + diff;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    this.maxUpstreamRequested = u;
                    continue;
                }
                if (ur == 0L || p == null) continue;
                this.maxUpstreamRequested = 0L;
                p.request(ur);
            } while ((missed = this.management.addAndGet(-missed)) != 0);
        }
    }
}

