/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.reactive;

import com.forgerock.reactive.ReactiveHandler;
import com.forgerock.reactive.RxJavaStreams;
import com.forgerock.reactive.Stream;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.io.IOException;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.AbstractLDAPMessageHandler;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPClientContextEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.RuntimeExceptionHandler;

@Deprecated
public final class ServerConnectionFactoryAdapter
implements Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> {
    private final ServerConnectionFactory<LDAPClientContext, Integer> adaptee;
    private final DecodeOptions decodeOptions;

    public ServerConnectionFactoryAdapter(DecodeOptions decodeOptions, ServerConnectionFactory<LDAPClientContext, Integer> serverConnectionFactory) {
        this.decodeOptions = Reject.checkNotNull(decodeOptions, "decodeOptions must not be null");
        this.adaptee = Reject.checkNotNull(serverConnectionFactory, "serverConnectionFactory must not be null");
    }

    @Override
    public ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>> apply(LDAPClientContext clientContext) throws LdapException {
        return new ServerConnectionAdapter(clientContext, this.decodeOptions, this.adaptee.handleAccept(clientContext));
    }

    public static final class ServerConnectionAdapter
    implements ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>> {
        private final ServerConnection<Integer> adaptee;
        private final DecodeOptions decodeOptions;

        public ServerConnectionAdapter(LDAPClientContext clientContext, DecodeOptions decodeOptions, ServerConnection<Integer> serverConnection) {
            this.decodeOptions = Reject.checkNotNull(decodeOptions, "decodeOptions must not be null");
            this.adaptee = Reject.checkNotNull(serverConnection, "serverConnection must not be null");
            clientContext.addListener(new LDAPClientContextEventListener(){

                @Override
                public void handleConnectionError(LDAPClientContext context, Throwable error) {
                    adaptee.handleConnectionError(error);
                }

                @Override
                public void handleConnectionClosed(LDAPClientContext context, UnbindRequest unbindRequest) {
                    if (unbindRequest == null) {
                        adaptee.handleConnectionClosed(null, null);
                    } else {
                        adaptee.handleConnectionClosed(0, unbindRequest);
                    }
                }

                @Override
                public void handleConnectionDisconnected(LDAPClientContext context, ResultCode resultCode, String diagnosticMessage) {
                    adaptee.handleConnectionDisconnected(resultCode, diagnosticMessage);
                }
            });
        }

        @Override
        public Stream<Response> handle(LDAPClientContext context, LdapMessages.LdapRequestEnvelope request) throws Exception {
            final LDAPReader<ASN1Reader> reader = LDAP.getReader((ASN1Reader)request.getContent(), this.decodeOptions);
            return RxJavaStreams.streamFromPublisher(Flowable.create(new FlowableOnSubscribe<Response>(){

                @Override
                public void subscribe(final FlowableEmitter<Response> emitter) throws Exception {
                    reader.readMessage(new AbstractLDAPMessageHandler(){

                        @Override
                        public void abandonRequest(int messageID, AbandonRequest request) throws DecodeException, IOException {
                            this.handleAbandon(messageID, request, emitter);
                        }

                        @Override
                        public void addRequest(int messageID, AddRequest request) throws DecodeException, IOException {
                            this.handleAdd(messageID, request, emitter);
                        }

                        @Override
                        public void deleteRequest(int messageID, DeleteRequest request) throws DecodeException, IOException {
                            this.handleDelete(messageID, request, emitter);
                        }

                        @Override
                        public void bindRequest(int messageID, int version, GenericBindRequest request) throws DecodeException, IOException {
                            this.handleBind(messageID, version, request, emitter);
                        }

                        @Override
                        public void compareRequest(int messageID, CompareRequest request) throws DecodeException, IOException {
                            this.handleCompare(messageID, request, emitter);
                        }

                        @Override
                        public <R extends ExtendedResult> void extendedRequest(int messageID, ExtendedRequest<R> request) throws DecodeException, IOException {
                            this.handleExtendedRequest(messageID, request, emitter);
                        }

                        @Override
                        public void modifyDNRequest(int messageID, ModifyDNRequest request) throws DecodeException, IOException {
                            this.handleModifyDN(messageID, request, emitter);
                        }

                        @Override
                        public void modifyRequest(int messageID, ModifyRequest request) throws DecodeException, IOException {
                            this.handleModify(messageID, request, emitter);
                        }

                        @Override
                        public void searchRequest(int messageID, SearchRequest request) throws DecodeException, IOException {
                            this.handleSearch(messageID, request, emitter);
                        }

                        @Override
                        public void unbindRequest(int messageID, UnbindRequest request) throws DecodeException, IOException {
                        }
                    });
                }
            }, BackpressureStrategy.ERROR));
        }

        void handleAdd(int requestId, AddRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<Result> resultAdapter = new ResultHandlerAdapter<Result>(responseEmitter);
            this.adaptee.handleAdd(requestId, request, resultAdapter, resultAdapter);
        }

        void handleBind(int requestId, int version, BindRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<BindResult> resultAdapter = new ResultHandlerAdapter<BindResult>(responseEmitter);
            this.adaptee.handleBind(requestId, version, request, resultAdapter, resultAdapter);
        }

        void handleCompare(int requestId, CompareRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<CompareResult> resultAdapter = new ResultHandlerAdapter<CompareResult>(responseEmitter);
            this.adaptee.handleCompare(requestId, request, resultAdapter, resultAdapter);
        }

        void handleDelete(int requestId, DeleteRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<Result> resultAdapter = new ResultHandlerAdapter<Result>(responseEmitter);
            this.adaptee.handleDelete(requestId, request, resultAdapter, resultAdapter);
        }

        <R extends ExtendedResult> void handleExtendedRequest(int requestId, ExtendedRequest<R> request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter resultAdapter = new ResultHandlerAdapter(responseEmitter);
            this.adaptee.handleExtendedRequest(requestId, request, resultAdapter, resultAdapter);
        }

        void handleModify(int requestId, ModifyRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<Result> resultAdapter = new ResultHandlerAdapter<Result>(responseEmitter);
            this.adaptee.handleModify(requestId, request, resultAdapter, resultAdapter);
        }

        void handleModifyDN(int requestId, ModifyDNRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<Result> resultAdapter = new ResultHandlerAdapter<Result>(responseEmitter);
            this.adaptee.handleModifyDN(requestId, request, resultAdapter, resultAdapter);
        }

        void handleSearch(int requestId, SearchRequest request, FlowableEmitter<Response> responseEmitter) {
            ResultHandlerAdapter<Result> resultAdapter = new ResultHandlerAdapter<Result>(responseEmitter);
            this.adaptee.handleSearch(requestId, request, resultAdapter, resultAdapter, resultAdapter);
        }

        void handleAbandon(int requestId, AbandonRequest request, FlowableEmitter<Response> emitter) {
            this.adaptee.handleAbandon(requestId, request);
        }

        private static final class ResultHandlerAdapter<R extends Response>
        implements IntermediateResponseHandler,
        SearchResultHandler,
        LdapResultHandler<R>,
        RuntimeExceptionHandler {
            private final FlowableEmitter<Response> adaptee;

            ResultHandlerAdapter(FlowableEmitter<Response> emitter) {
                this.adaptee = emitter;
            }

            @Override
            public boolean handleEntry(SearchResultEntry entry) {
                this.adaptee.onNext(entry);
                return true;
            }

            @Override
            public boolean handleReference(SearchResultReference reference) {
                this.adaptee.onNext(reference);
                return true;
            }

            @Override
            public boolean handleIntermediateResponse(IntermediateResponse intermediateResponse) {
                this.adaptee.onNext(intermediateResponse);
                return true;
            }

            @Override
            public void handleResult(R result) {
                if (result != null) {
                    this.adaptee.onNext((Response)result);
                }
                this.adaptee.onComplete();
            }

            @Override
            public void handleRuntimeException(RuntimeException exception) {
                this.adaptee.onError(exception);
            }

            @Override
            public void handleException(LdapException exception) {
                this.adaptee.onError(exception);
            }
        }
    }
}

