/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.reactive;

import com.forgerock.reactive.Action;
import com.forgerock.reactive.Completable;
import com.forgerock.reactive.Consumer;
import com.forgerock.reactive.Single;
import com.forgerock.reactive.Stream;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class RxJavaStreams {
    private RxJavaStreams() {
    }

    public static <V> Stream<V> streamFromPublisher(Publisher<V> publisher) {
        return new RxJavaStream(Flowable.fromPublisher(publisher));
    }

    public static <V> Stream<V> streamFrom(V value) {
        return new RxJavaStream(Flowable.just(value));
    }

    public static <V> Stream<V> streamError(Throwable error) {
        return new RxJavaStream(Flowable.error(error));
    }

    public static <V> Stream<V> emptyStream() {
        return new RxJavaStream(Flowable.empty());
    }

    public static <V> Single<V> singleFromPublisher(Publisher<V> publisher) {
        return new RxJavaSingle(io.reactivex.Single.fromPublisher(publisher));
    }

    public static <V> Single<V> singleFrom(V value) {
        return new RxJavaSingle(io.reactivex.Single.just(value));
    }

    public static <V> Single<V> singleError(Throwable error) {
        return new RxJavaSingle(io.reactivex.Single.error(error));
    }

    public static <V> Single<V> newSingle(final Single.Emitter<V> emitter) {
        return new RxJavaSingle(io.reactivex.Single.create(new SingleOnSubscribe<V>(){

            @Override
            public void subscribe(final SingleEmitter<V> e) throws Exception {
                emitter.subscribe(new Single.Subscriber<V>(){

                    @Override
                    public void onComplete(V value) {
                        e.onSuccess(value);
                    }

                    @Override
                    public void onError(Throwable error) {
                        e.onError(error);
                    }
                });
            }
        }));
    }

    public static Completable newCompletable(final Completable.Emitter onSubscribe) {
        return new RxJavaCompletable(io.reactivex.Completable.create(new CompletableOnSubscribe(){

            @Override
            public void subscribe(final CompletableEmitter e) throws Exception {
                onSubscribe.subscribe(new Completable.Subscriber(){

                    @Override
                    public void onComplete() {
                        e.onComplete();
                    }

                    @Override
                    public void onError(Throwable error) {
                        e.onError(error);
                    }
                });
            }
        }));
    }

    public static Completable completableError(Throwable error) {
        return new RxJavaCompletable(io.reactivex.Completable.error(error));
    }

    private static final class RxJavaCompletable
    implements Completable {
        private final io.reactivex.Completable impl;

        RxJavaCompletable(io.reactivex.Completable impl) {
            this.impl = impl;
        }

        @Override
        public <V> Single<V> toSingle(V value) {
            return new RxJavaSingle(this.impl.toSingleDefault(value));
        }

        @Override
        public void subscribe(Subscriber<? super Void> s) {
            this.impl.toFlowable().subscribe(s);
        }

        @Override
        public Completable onErrorResumeWith(final org.forgerock.util.Function<Throwable, Completable, Exception> function) {
            return new RxJavaCompletable(this.impl.onErrorResumeNext((Function<? super Throwable, ? extends CompletableSource>)new Function<Throwable, CompletableSource>(){

                @Override
                public CompletableSource apply(Throwable error) throws Exception {
                    return io.reactivex.Completable.fromPublisher((Publisher)function.apply(error));
                }
            }));
        }

        @Override
        public void subscribe(final Action completeAction, final Consumer<Throwable> errorConsumer) {
            this.impl.subscribe(new io.reactivex.functions.Action(){

                @Override
                public void run() throws Exception {
                    completeAction.run();
                }
            }, (io.reactivex.functions.Consumer<? super Throwable>)new io.reactivex.functions.Consumer<Throwable>(){

                @Override
                public void accept(Throwable error) throws Exception {
                    errorConsumer.accept(error);
                }
            });
        }

        @Override
        public Completable doAfterTerminate(final Action onTerminate) {
            return new RxJavaCompletable(this.impl.doAfterTerminate(new io.reactivex.functions.Action(){

                @Override
                public void run() throws Exception {
                    onTerminate.run();
                }
            }));
        }

        @Override
        public void subscribe() {
            this.impl.subscribe();
        }
    }

    private static final class RxJavaSingle<V>
    implements Single<V> {
        private final io.reactivex.Single<V> impl;

        private RxJavaSingle(io.reactivex.Single<V> impl) {
            this.impl = impl;
        }

        @Override
        public Stream<V> toStream() {
            return new RxJavaStream(this.impl.toFlowable());
        }

        @Override
        public <O> Single<O> map(final org.forgerock.util.Function<V, O, Exception> function) {
            return new RxJavaSingle(this.impl.map(new Function<V, O>(){

                @Override
                public O apply(V t) throws Exception {
                    return function.apply(t);
                }
            }));
        }

        @Override
        public void subscribe(Subscriber<? super V> s) {
            this.impl.toFlowable().subscribe(s);
        }

        @Override
        public void subscribe(final Consumer<? super V> resultConsumer, final Consumer<Throwable> errorConsumer) {
            this.impl.subscribe(new io.reactivex.functions.Consumer<V>(){

                @Override
                public void accept(V t) throws Exception {
                    resultConsumer.accept(t);
                }
            }, new io.reactivex.functions.Consumer<Throwable>(){

                @Override
                public void accept(Throwable t) throws Exception {
                    errorConsumer.accept(t);
                }
            });
        }

        @Override
        public <O> Single<O> flatMap(final org.forgerock.util.Function<V, Single<O>, Exception> function) {
            return new RxJavaSingle(this.impl.flatMap(new Function<V, SingleSource<O>>(){

                @Override
                public SingleSource<O> apply(V t) throws Exception {
                    return io.reactivex.Single.fromPublisher((Publisher)function.apply(t));
                }
            }));
        }

        @Override
        public Single<V> onErrorResumeWith(final org.forgerock.util.Function<Throwable, Single<V>, Exception> function) {
            return new RxJavaSingle<V>(this.impl.onErrorResumeNext(new Function<Throwable, SingleSource<V>>(){

                @Override
                public SingleSource<V> apply(Throwable error) throws Exception {
                    return io.reactivex.Single.fromPublisher((Publisher)function.apply(error));
                }
            }));
        }
    }

    private static final class RxJavaStream<V>
    implements Stream<V> {
        private final Flowable<V> impl;

        private RxJavaStream(Flowable<V> impl) {
            this.impl = impl;
        }

        @Override
        public void subscribe(Subscriber<? super V> s) {
            this.impl.subscribe(s);
        }

        @Override
        public <O> Stream<O> map(final org.forgerock.util.Function<V, O, Exception> function) {
            return new RxJavaStream(this.impl.map(new Function<V, O>(){

                @Override
                public O apply(V t) throws Exception {
                    return function.apply(t);
                }
            }));
        }

        @Override
        public <O> Stream<O> flatMap(final org.forgerock.util.Function<? super V, ? extends Publisher<? extends O>, Exception> function, int maxConcurrency) {
            return new RxJavaStream(this.impl.flatMap(new Function<V, Publisher<? extends O>>(){

                @Override
                public Publisher<? extends O> apply(V t) throws Exception {
                    return (Publisher)function.apply(t);
                }
            }, maxConcurrency));
        }

        @Override
        public Stream<V> onNext(final Consumer<V> onNext) {
            return new RxJavaStream<V>(this.impl.doOnNext(new io.reactivex.functions.Consumer<V>(){

                @Override
                public void accept(V value) throws Exception {
                    onNext.accept(value);
                }
            }));
        }

        @Override
        public Stream<V> onError(final Consumer<Throwable> onError) {
            return new RxJavaStream<V>(this.impl.doOnError(new io.reactivex.functions.Consumer<Throwable>(){

                @Override
                public void accept(Throwable t) throws Exception {
                    onError.accept(t);
                }
            }));
        }

        @Override
        public Stream<V> onErrorResumeWith(final org.forgerock.util.Function<Throwable, Publisher<V>, Exception> function) {
            return new RxJavaStream<V>(this.impl.onErrorResumeNext(new Function<Throwable, Publisher<? extends V>>(){

                @Override
                public Publisher<? extends V> apply(Throwable t) throws Exception {
                    return (Publisher)function.apply(t);
                }
            }));
        }

        @Override
        public Stream<V> onComplete(final Action action) {
            return new RxJavaStream<V>(this.impl.doOnComplete(new io.reactivex.functions.Action(){

                @Override
                public void run() throws Exception {
                    action.run();
                }
            }));
        }

        @Override
        public void subscribe() {
            this.impl.subscribe();
        }
    }
}

