/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.reactive;

import com.forgerock.reactive.ReactiveHandler;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

public abstract class ReactiveFilter<C, I1, O1, I2, O2> {
    public ReactiveFilter<C, I1, O1, I2, O2> andThen(boolean condition, final ReactiveFilter<C, I2, O2, I2, O2> next) {
        if (!condition) {
            return this;
        }
        return new ConcatenatedFilter(new Function<ReactiveHandler<C, I2, O2>, ReactiveHandler<C, I1, O1>, NeverThrowsException>(){

            @Override
            public ReactiveHandler<C, I1, O1> apply(ReactiveHandler<C, I2, O2> handler) {
                return ReactiveFilter.this.andThen(next.andThen(handler));
            }
        });
    }

    public <I3, O3> ReactiveFilter<C, I1, O1, I3, O3> andThen(final ReactiveFilter<C, I2, O2, I3, O3> next) {
        return new ConcatenatedFilter(new Function<ReactiveHandler<C, I3, O3>, ReactiveHandler<C, I1, O1>, NeverThrowsException>(){

            @Override
            public ReactiveHandler<C, I1, O1> apply(ReactiveHandler<C, I3, O3> handler) {
                return ReactiveFilter.this.andThen(next.andThen(handler));
            }
        });
    }

    public ReactiveFilter<C, I1, O1, I2, O2> andThen(final SimpleReactiveFilter<C, I2, O2> next) {
        return new ConcatenatedFilter(new Function<ReactiveHandler<C, I2, O2>, ReactiveHandler<C, I1, O1>, NeverThrowsException>(){

            @Override
            public ReactiveHandler<C, I1, O1> apply(ReactiveHandler<C, I2, O2> handler) {
                return ReactiveFilter.this.andThen(next.andThen(handler));
            }
        });
    }

    public ReactiveHandler<C, I1, O1> andThen(final ReactiveHandler<C, I2, O2> handler) {
        final ReactiveFilter parent = this;
        return new ReactiveHandler<C, I1, O1>(){

            @Override
            public O1 handle(C context, I1 request) throws Exception {
                return parent.filter(context, request, handler);
            }
        };
    }

    public abstract O1 filter(C var1, I1 var2, ReactiveHandler<C, I2, O2> var3) throws Exception;

    private static final class ConcatenatedFilter<C, I1, O1, I2, O2>
    extends ReactiveFilter<C, I1, O1, I2, O2> {
        private final Function<ReactiveHandler<C, I2, O2>, ReactiveHandler<C, I1, O1>, NeverThrowsException> converter;

        ConcatenatedFilter(Function<ReactiveHandler<C, I2, O2>, ReactiveHandler<C, I1, O1>, NeverThrowsException> converter) {
            this.converter = converter;
        }

        @Override
        public <I3, O3> ReactiveFilter<C, I1, O1, I3, O3> andThen(final ReactiveFilter<C, I2, O2, I3, O3> nextFilter) {
            return new ConcatenatedFilter<C, I1, O1, I2, O2>(new Function<ReactiveHandler<C, I3, O3>, ReactiveHandler<C, I1, O1>, NeverThrowsException>(){

                @Override
                public ReactiveHandler<C, I1, O1> apply(ReactiveHandler<C, I3, O3> handler) {
                    return (ReactiveHandler)converter.apply(nextFilter.andThen(handler));
                }
            });
        }

        @Override
        public ReactiveHandler<C, I1, O1> andThen(ReactiveHandler<C, I2, O2> handler) {
            return this.converter.apply(handler);
        }

        @Override
        public O1 filter(C context, I1 request, ReactiveHandler<C, I2, O2> handler) throws Exception {
            return this.converter.apply(handler).handle(context, request);
        }
    }

    public static abstract class SimpleReactiveFilter<C, I, O>
    extends ReactiveFilter<C, I, O, I, O> {
    }
}

