/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.ASCIICharProp;
import com.forgerock.opendj.util.FipsStaticUtils;
import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ProviderNotFoundException;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

public final class StaticUtils {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final boolean DEBUG_ENABLED = System.getProperty("org.forgerock.opendj.debug") != null;
    private static final boolean DEBUG_TO_STDERR = System.getProperty("org.forgerock.opendj.debug.stderr") != null;
    public static final String EOL;
    public static final byte[] EMPTY_BYTES;
    private static final String TIME_ZONE_UTC = "UTC";
    private static final TimeZone TIME_ZONE_UTC_OBJ;
    private static final String[][] BYTE_HEX_STRINGS;
    private static final int UPPER_CASE = 0;
    private static final int LOWER_CASE = 1;
    public static final ReferenceCountedObject<ScheduledExecutorService> DEFAULT_SCHEDULER;

    public static String byteToHex(byte b) {
        return BYTE_HEX_STRINGS[0][b & 0xFF];
    }

    public static String byteToLowerHex(byte b) {
        return BYTE_HEX_STRINGS[1][b & 0xFF];
    }

    public static String formatAsGeneralizedTime(Date date) {
        return StaticUtils.formatAsGeneralizedTime(date.getTime());
    }

    public static String formatAsGeneralizedTime(long date) {
        StringBuilder sb = new StringBuilder(19);
        GregorianCalendar calendar = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
        calendar.setLenient(false);
        calendar.setTimeInMillis(date);
        int n = calendar.get(1);
        if (n < 0) {
            IllegalArgumentException e = new IllegalArgumentException("Year cannot be < 0:" + n);
            throw e;
        }
        if (n < 10) {
            sb.append("000");
        } else if (n < 100) {
            sb.append("00");
        } else if (n < 1000) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(2) + 1;
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(5);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(11);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(12);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(13);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        sb.append('.');
        n = calendar.get(14);
        if (n < 10) {
            sb.append("00");
        } else if (n < 100) {
            sb.append("0");
        }
        sb.append(n);
        sb.append('Z');
        return sb.toString();
    }

    public static byte[] getBytes(char[] chars) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer buffer = utf8.encode(CharBuffer.wrap(chars));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] getBytes(CharSequence s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        byte[] returnArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            returnArray[i] = (byte)(c & 0x7F);
            if (c == returnArray[i]) continue;
            try {
                return s.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to encode UTF-8 string " + s, e);
            }
        }
        return returnArray;
    }

    public static LocalizableMessage getExceptionMessage(Throwable t) {
        if (t instanceof LocalizableException) {
            LocalizableException ie = (LocalizableException)((Object)t);
            return ie.getMessageObject();
        }
        if (t instanceof NullPointerException) {
            StackTraceElement[] stackElements = t.getStackTrace();
            LocalizableMessageBuilder message = new LocalizableMessageBuilder();
            message.append("NullPointerException(");
            message.append(stackElements[0].getFileName());
            message.append(":");
            message.append(stackElements[0].getLineNumber());
            message.append(")");
            return message.toMessage();
        }
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return StaticUtils.getExceptionMessage(t.getCause());
        }
        StringBuilder message = new StringBuilder();
        String className = t.getClass().getName();
        int periodPos = className.lastIndexOf(46);
        if (periodPos > 0) {
            message.append(className.substring(periodPos + 1));
        } else {
            message.append(className);
        }
        message.append("(");
        if (t.getMessage() == null) {
            StackTraceElement[] stackElements = t.getStackTrace();
            message.append(stackElements[0].getFileName());
            message.append(":");
            message.append(stackElements[0].getLineNumber());
            if (t instanceof IllegalStateException) {
                for (int i = 1; i < stackElements.length; ++i) {
                    message.append(' ');
                    message.append(stackElements[i].getFileName());
                    message.append(":");
                    message.append(stackElements[i].getLineNumber());
                }
            }
        } else {
            message.append(t.getMessage());
        }
        message.append(")");
        return LocalizableMessage.raw(message.toString(), new Object[0]);
    }

    public static boolean isAlpha(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isLetter() : false;
    }

    public static boolean isDigit(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isDigit() : false;
    }

    public static boolean isHexDigit(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isHexDigit() : false;
    }

    public static boolean isKeyChar(char c, boolean allowCompatChars) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isKeyChar(allowCompatChars) : false;
    }

    public static String stackTraceToSingleLineString(Throwable throwable, boolean isFullStack) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.stackTraceToSingleLineString(buffer, throwable, isFullStack);
        return buffer.toString();
    }

    public static void stackTraceToSingleLineString(StringBuilder buffer, Throwable throwable, boolean isFullStack) {
        if (throwable == null) {
            return;
        }
        if (isFullStack) {
            buffer.append(throwable.getClass().getName());
            String message = throwable.getLocalizedMessage();
            if (message != null && message.length() != 0) {
                buffer.append(": ").append(message);
            }
            for (StackTraceElement e : throwable.getStackTrace()) {
                buffer.append(" / ");
                buffer.append(e.getFileName());
                buffer.append(":");
                buffer.append(e.getLineNumber());
            }
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
                buffer.append("; caused by ");
                buffer.append(throwable);
                for (StackTraceElement e : throwable.getStackTrace()) {
                    buffer.append(" / ");
                    buffer.append(e.getFileName());
                    buffer.append(":");
                    buffer.append(e.getLineNumber());
                }
            }
        } else {
            if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            buffer.append(throwable.getClass().getSimpleName());
            String message = throwable.getLocalizedMessage();
            if (message != null && message.length() != 0) {
                buffer.append(": ").append(message);
            }
            int i = 0;
            buffer.append(" (");
            for (StackTraceElement e : throwable.getStackTrace()) {
                if (i > 20) {
                    buffer.append(" ...");
                    break;
                }
                if (i > 0) {
                    buffer.append(" ");
                }
                buffer.append(e.getFileName());
                buffer.append(":");
                buffer.append(e.getLineNumber());
                ++i;
            }
            buffer.append(")");
        }
    }

    public static StringBuilder toLowerCase(ByteSequence b, StringBuilder builder) {
        Reject.ifNull(b, builder);
        int origBufferLen = builder.length();
        int length = b.length();
        for (int i = 0; i < length; ++i) {
            byte c = b.byteAt(i);
            if (c < 0) {
                builder.replace(origBufferLen, builder.length(), b.toString().toLowerCase(Locale.ENGLISH));
                return builder;
            }
            ASCIICharProp cp = ASCIICharProp.valueOf(c);
            builder.append(cp.toLowerCase());
        }
        return builder;
    }

    public static String toLowerCase(String s) {
        int i;
        Reject.ifNull(s);
        int length = s.length();
        ASCIICharProp cp = null;
        for (i = 0; i < length && (cp = ASCIICharProp.valueOf(s.charAt(i))) != null && !cp.isUpperCase(); ++i) {
        }
        if (i == length) {
            return s;
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(s, 0, i);
        if (cp != null) {
            builder.append(cp.toLowerCase());
            ++i;
            while (i < length && (cp = ASCIICharProp.valueOf(s.charAt(i))) != null) {
                builder.append(cp.toLowerCase());
                ++i;
            }
        }
        if (i < length) {
            builder.append(s.substring(i).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    public static StringBuilder toLowerCase(String s, StringBuilder builder) {
        Reject.ifNull(s);
        Reject.ifNull(builder);
        int length = s.length();
        builder.ensureCapacity(builder.length() + length);
        for (int i = 0; i < length; ++i) {
            ASCIICharProp cp = ASCIICharProp.valueOf(s.charAt(i));
            if (cp == null) {
                builder.append(s.substring(i).toLowerCase(Locale.ENGLISH));
                return builder;
            }
            builder.append(cp.toLowerCase());
        }
        return builder;
    }

    public static byte[] copyOfBytes(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static StackTraceElement[] getStackTraceIfDebugEnabled() {
        if (!DEBUG_ENABLED) {
            return null;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return Arrays.copyOfRange(stack, 2, stack.length);
    }

    public static void logIfDebugEnabled(String msg, StackTraceElement[] stackTrace) {
        if (DEBUG_ENABLED) {
            StringBuilder builder = new StringBuilder("OPENDJ SDK: ");
            builder.append(msg);
            if (stackTrace != null) {
                builder.append(EOL);
                for (StackTraceElement e : stackTrace) {
                    builder.append("\tat ");
                    builder.append(e);
                    builder.append(EOL);
                }
            }
            if (DEBUG_TO_STDERR) {
                System.err.println(builder);
            } else {
                logger.error(LocalizableMessage.raw("%s", builder));
            }
        }
    }

    public static char byteToASCII(byte b) {
        if (StaticUtils.isPrintable(b)) {
            return (char)b;
        }
        return ' ';
    }

    public static boolean isPrintable(byte b) {
        return 32 <= b && b <= 126;
    }

    private StaticUtils() {
    }

    public static <P extends org.forgerock.opendj.ldap.spi.Provider> P getProvider(Class<P> providerClass, String requestedProvider, ClassLoader classLoader) {
        ServiceLoader<org.forgerock.opendj.ldap.spi.Provider> loader = null;
        loader = classLoader != null ? ServiceLoader.load(providerClass, classLoader) : ServiceLoader.load(providerClass, providerClass.getClassLoader());
        StringBuilder providersFound = new StringBuilder();
        for (org.forgerock.opendj.ldap.spi.Provider provider : loader) {
            if (providersFound.length() > 0) {
                providersFound.append(" ");
            }
            providersFound.append(provider.getName());
            if (requestedProvider != null && !provider.getName().equals(requestedProvider)) continue;
            return (P)provider;
        }
        if (providersFound.length() > 0) {
            throw new ProviderNotFoundException(providerClass, requestedProvider, String.format("The requested provider '%s' of type '%s' was not found. Available providers: %s", requestedProvider, providerClass.getName(), providersFound));
        }
        throw new ProviderNotFoundException(providerClass, requestedProvider, String.format("There was no provider of type '%s' available.", providerClass.getName()));
    }

    public static boolean isFips() {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getName().toLowerCase().contains("fips")) continue;
            return true;
        }
        return false;
    }

    public static void registerBcProvider() {
        try {
            FipsStaticUtils.registerBcProvider();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static {
        StaticUtils.logIfDebugEnabled("debugging enabled", null);
        EOL = System.getProperty("line.separator");
        EMPTY_BYTES = new byte[0];
        TIME_ZONE_UTC_OBJ = TimeZone.getTimeZone(TIME_ZONE_UTC);
        BYTE_HEX_STRINGS = new String[2][256];
        String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        for (int i = 0; i < 256; ++i) {
            StaticUtils.BYTE_HEX_STRINGS[0][i] = hexDigits[i >>> 4] + hexDigits[i & 0xF];
            StaticUtils.BYTE_HEX_STRINGS[1][i] = BYTE_HEX_STRINGS[0][i].toLowerCase();
        }
        DEFAULT_SCHEDULER = new ReferenceCountedObject<ScheduledExecutorService>(){

            @Override
            protected ScheduledExecutorService newInstance() {
                ThreadFactory factory = Utils.newThreadFactory(null, "OpenDJ LDAP SDK Default Scheduler", true);
                return Executors.newSingleThreadScheduledExecutor(factory);
            }

            @Override
            protected void destroyInstance(ScheduledExecutorService instance) {
                instance.shutdownNow();
            }
        };
    }
}

