/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.security.Provider;
import java.security.Security;
import org.forgerock.i18n.slf4j.LocalizedLogger;

public class FipsStaticUtils {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String BC_PROVIDER_NAME = "BC";
    public static final String BC_FIPS_PROVIDER_NAME = "BCFIPS";
    private static final String BC_GENERIC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String BC_FIPS_PROVIDER_CLASS_NAME = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";

    public static void registerBcProvider() {
        if (!StaticUtils.isFips()) {
            return;
        }
        String providerName = BC_PROVIDER_NAME;
        String className = BC_GENERIC_PROVIDER_CLASS_NAME;
        boolean bcFipsProvider = FipsStaticUtils.checkBcFipsProvider();
        if (bcFipsProvider) {
            logger.info(CoreMessages.INFO_BC_FIPS_PROVIDER_REGISTER);
            providerName = BC_FIPS_PROVIDER_NAME;
            className = BC_FIPS_PROVIDER_CLASS_NAME;
        } else {
            logger.info(CoreMessages.INFO_BC_PROVIDER_REGISTER.get());
        }
        FipsStaticUtils.installBCProvider(providerName, className);
    }

    private static void installBCProvider(String providerName, String providerClassName) {
        Provider bouncyCastleProvider = Security.getProvider(providerName);
        if (bouncyCastleProvider == null) {
            try {
                bouncyCastleProvider = (Provider)Class.forName(providerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                Security.insertProviderAt(bouncyCastleProvider, 1);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                logger.error(CoreMessages.INFO_BC_PROVIDER_FAILED_TO_CREATE.get());
            }
        } else {
            logger.info(CoreMessages.INFO_BC_PROVIDER_REGISTERED_ALREADY.get());
        }
    }

    private static boolean checkBcFipsProvider() {
        try {
            Class.forName(BC_FIPS_PROVIDER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.trace(CoreMessages.INFO_BC_FIPS_PROVIDER_NOT_EXISTS.get(), (Throwable)e);
            return false;
        }
        return true;
    }
}

