/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class AccountUsabilityResponseControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.4.1.42.2.27.9.5.8";
    public static final ControlDecoder<AccountUsabilityResponseControl> DECODER = new ControlDecoder<AccountUsabilityResponseControl>(){

        @Override
        public AccountUsabilityResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof AccountUsabilityResponseControl) {
                return (AccountUsabilityResponseControl)control;
            }
            if (!control.getOID().equals(AccountUsabilityResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLERES_CONTROL_BAD_OID.get(control.getOID(), AccountUsabilityResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLERES_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            try {
                ASN1Reader reader = ASN1.getReader(control.getValue());
                switch (reader.peekType()) {
                    case -128: {
                        int secondsBeforeExpiration = (int)reader.readInteger();
                        return new AccountUsabilityResponseControl(control.isCritical(), true, false, false, false, -1, false, 0, secondsBeforeExpiration);
                    }
                    case -95: {
                        boolean isInactive = false;
                        boolean isReset = false;
                        boolean isExpired = false;
                        boolean isLocked = false;
                        int remainingGraceLogins = -1;
                        int secondsBeforeUnlock = 0;
                        reader.readStartSequence();
                        if (reader.hasNextElement() && reader.peekType() == -128) {
                            isInactive = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -127) {
                            isReset = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -126) {
                            isExpired = reader.readBoolean();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -125) {
                            remainingGraceLogins = (int)reader.readInteger();
                        }
                        if (reader.hasNextElement() && reader.peekType() == -124) {
                            isLocked = true;
                            secondsBeforeUnlock = (int)reader.readInteger();
                        }
                        reader.readEndSequence();
                        return new AccountUsabilityResponseControl(control.isCritical(), false, isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock, -1);
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLERES_UNKNOWN_VALUE_ELEMENT_TYPE.get(StaticUtils.byteToHex(reader.peekType()));
                throw DecodeException.error(message);
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("%s", e));
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLERES_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
        }

        @Override
        public String getOID() {
            return AccountUsabilityResponseControl.OID;
        }
    };
    private static final byte TYPE_SECONDS_BEFORE_EXPIRATION = -128;
    private static final byte TYPE_MORE_INFO = -95;
    private static final byte TYPE_INACTIVE = -128;
    private static final byte TYPE_RESET = -127;
    private static final byte TYPE_EXPIRED = -126;
    private static final byte TYPE_REMAINING_GRACE_LOGINS = -125;
    private static final byte TYPE_SECONDS_BEFORE_UNLOCK = -124;
    private final boolean isUsable;
    private final boolean isExpired;
    private final boolean isInactive;
    private final boolean isLocked;
    private final boolean isReset;
    private final int remainingGraceLogins;
    private final int secondsBeforeExpiration;
    private final int secondsBeforeUnlock;
    private final boolean isCritical;

    public static AccountUsabilityResponseControl newControl(boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock) {
        return new AccountUsabilityResponseControl(false, false, isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock, -1);
    }

    public static AccountUsabilityResponseControl newControl(int secondsBeforeExpiration) {
        return new AccountUsabilityResponseControl(false, true, false, false, false, -1, false, 0, secondsBeforeExpiration);
    }

    private AccountUsabilityResponseControl(boolean isCritical, boolean isUsable, boolean isInactive, boolean isReset, boolean isExpired, int remainingGraceLogins, boolean isLocked, int secondsBeforeUnlock, int secondsBeforeExpiration) {
        this.isCritical = isCritical;
        this.isUsable = isUsable;
        this.isInactive = isInactive;
        this.isReset = isReset;
        this.isExpired = isExpired;
        this.remainingGraceLogins = remainingGraceLogins;
        this.isLocked = isLocked;
        this.secondsBeforeUnlock = secondsBeforeUnlock;
        this.secondsBeforeExpiration = secondsBeforeExpiration;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public int getRemainingGraceLogins() {
        return this.remainingGraceLogins;
    }

    public int getSecondsBeforeExpiration() {
        return this.secondsBeforeExpiration;
    }

    public int getSecondsBeforeUnlock() {
        return this.secondsBeforeUnlock;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            if (this.secondsBeforeExpiration < 0) {
                writer.writeInteger((byte)-128, this.secondsBeforeExpiration);
            } else {
                writer.writeStartSequence((byte)-95);
                if (this.isInactive) {
                    writer.writeBoolean((byte)-128, true);
                }
                if (this.isReset) {
                    writer.writeBoolean((byte)-127, true);
                }
                if (this.isExpired) {
                    writer.writeBoolean((byte)-126, true);
                    if (this.remainingGraceLogins >= 0) {
                        writer.writeInteger((byte)-125, this.remainingGraceLogins);
                    }
                }
                if (this.isLocked) {
                    writer.writeInteger((byte)-124, this.secondsBeforeUnlock);
                }
                writer.writeEndSequence();
            }
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccountUsableResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", isUsable=");
        builder.append(this.isUsable);
        if (this.isUsable) {
            builder.append(",secondsBeforeExpiration=");
            builder.append(this.secondsBeforeExpiration);
        } else {
            builder.append(",isInactive=");
            builder.append(this.isInactive);
            builder.append(",isReset=");
            builder.append(this.isReset);
            builder.append(",isExpired=");
            builder.append(this.isExpired);
            builder.append(",remainingGraceLogins=");
            builder.append(this.remainingGraceLogins);
            builder.append(",isLocked=");
            builder.append(this.isLocked);
            builder.append(",secondsBeforeUnlock=");
            builder.append(this.secondsBeforeUnlock);
        }
        builder.append(")");
        return builder.toString();
    }
}

