/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RootDNUserCfgClient;
import org.forgerock.opendj.server.config.server.RootDNUserCfg;

public final class RootDNUserCfgDefn
extends ManagedObjectDefinition<RootDNUserCfgClient, RootDNUserCfg> {
    private static final RootDNUserCfgDefn INSTANCE = new RootDNUserCfgDefn();
    private static final DNPropertyDefinition PD_ALTERNATE_BIND_DN;

    public static RootDNUserCfgDefn getInstance() {
        return INSTANCE;
    }

    private RootDNUserCfgDefn() {
        super("root-dn-user", TopCfgDefn.getInstance());
    }

    @Override
    public RootDNUserCfgClient createClientConfiguration(ManagedObject<? extends RootDNUserCfgClient> impl) {
        return new RootDNUserCfgClientImpl(impl);
    }

    @Override
    public RootDNUserCfg createServerConfiguration(ServerManagedObject<? extends RootDNUserCfg> impl) {
        return new RootDNUserCfgServerImpl(impl);
    }

    @Override
    public Class<RootDNUserCfg> getServerConfigurationClass() {
        return RootDNUserCfg.class;
    }

    public DNPropertyDefinition getAlternateBindDNPropertyDefinition() {
        return PD_ALTERNATE_BIND_DN;
    }

    static {
        DNPropertyDefinition.Builder builder = DNPropertyDefinition.createBuilder(INSTANCE, "alternate-bind-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "alternate-bind-dn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "alternate-bind-dn"));
        PD_ALTERNATE_BIND_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALTERNATE_BIND_DN);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class RootDNUserCfgServerImpl
    implements RootDNUserCfg {
        private ServerManagedObject<? extends RootDNUserCfg> impl;
        private final SortedSet<DN> pAlternateBindDN;

        private RootDNUserCfgServerImpl(ServerManagedObject<? extends RootDNUserCfg> impl) {
            this.impl = impl;
            this.pAlternateBindDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAlternateBindDNPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<RootDNUserCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<RootDNUserCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DN> getAlternateBindDN() {
            return this.pAlternateBindDN;
        }

        @Override
        public Class<? extends RootDNUserCfg> configurationClass() {
            return RootDNUserCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class RootDNUserCfgClientImpl
    implements RootDNUserCfgClient {
        private ManagedObject<? extends RootDNUserCfgClient> impl;

        private RootDNUserCfgClientImpl(ManagedObject<? extends RootDNUserCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DN> getAlternateBindDN() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getAlternateBindDNPropertyDefinition());
        }

        @Override
        public void setAlternateBindDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getAlternateBindDNPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends RootDNUserCfgClient, ? extends RootDNUserCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

