/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.client.ReferentialIntegrityPluginCfgClient;
import org.forgerock.opendj.server.config.meta.PluginCfgDefn;
import org.forgerock.opendj.server.config.server.PluginCfg;
import org.forgerock.opendj.server.config.server.ReferentialIntegrityPluginCfg;

public final class ReferentialIntegrityPluginCfgDefn
extends ManagedObjectDefinition<ReferentialIntegrityPluginCfgClient, ReferentialIntegrityPluginCfg> {
    private static final ReferentialIntegrityPluginCfgDefn INSTANCE = new ReferentialIntegrityPluginCfgDefn();
    private static final AttributeTypePropertyDefinition PD_ATTRIBUTE_TYPE;
    private static final DNPropertyDefinition PD_BASE_DN;
    private static final BooleanPropertyDefinition PD_CHECK_REFERENCES;
    private static final StringPropertyDefinition PD_CHECK_REFERENCES_FILTER_CRITERIA;
    private static final EnumPropertyDefinition<CheckReferencesScopeCriteria> PD_CHECK_REFERENCES_SCOPE_CRITERIA;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LOG_FILE;
    private static final EnumPropertyDefinition<PluginCfgDefn.PluginType> PD_PLUGIN_TYPE;
    private static final DurationPropertyDefinition PD_UPDATE_INTERVAL;

    public static ReferentialIntegrityPluginCfgDefn getInstance() {
        return INSTANCE;
    }

    private ReferentialIntegrityPluginCfgDefn() {
        super("referential-integrity-plugin", PluginCfgDefn.getInstance());
    }

    @Override
    public ReferentialIntegrityPluginCfgClient createClientConfiguration(ManagedObject<? extends ReferentialIntegrityPluginCfgClient> impl) {
        return new ReferentialIntegrityPluginCfgClientImpl(impl);
    }

    @Override
    public ReferentialIntegrityPluginCfg createServerConfiguration(ServerManagedObject<? extends ReferentialIntegrityPluginCfg> impl) {
        return new ReferentialIntegrityPluginCfgServerImpl(impl);
    }

    @Override
    public Class<ReferentialIntegrityPluginCfg> getServerConfigurationClass() {
        return ReferentialIntegrityPluginCfg.class;
    }

    public AttributeTypePropertyDefinition getAttributeTypePropertyDefinition() {
        return PD_ATTRIBUTE_TYPE;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PD_BASE_DN;
    }

    public BooleanPropertyDefinition getCheckReferencesPropertyDefinition() {
        return PD_CHECK_REFERENCES;
    }

    public StringPropertyDefinition getCheckReferencesFilterCriteriaPropertyDefinition() {
        return PD_CHECK_REFERENCES_FILTER_CRITERIA;
    }

    public EnumPropertyDefinition<CheckReferencesScopeCriteria> getCheckReferencesScopeCriteriaPropertyDefinition() {
        return PD_CHECK_REFERENCES_SCOPE_CRITERIA;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluginCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getInvokeForInternalOperationsPropertyDefinition() {
        return PluginCfgDefn.getInstance().getInvokeForInternalOperationsPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLogFilePropertyDefinition() {
        return PD_LOG_FILE;
    }

    public EnumPropertyDefinition<PluginCfgDefn.PluginType> getPluginTypePropertyDefinition() {
        return PD_PLUGIN_TYPE;
    }

    public DurationPropertyDefinition getUpdateIntervalPropertyDefinition() {
        return PD_UPDATE_INTERVAL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "attribute-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "attribute-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ATTRIBUTE_TYPE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ATTRIBUTE_TYPE);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "base-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-dn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "base-dn"));
        PD_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_DN);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "check-references");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "check-references"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_CHECK_REFERENCES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECK_REFERENCES);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "check-references-filter-criteria");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "check-references-filter-criteria"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^[^:]+:\\(.+\\)$", "ATTRIBUTE:FILTER");
        PD_CHECK_REFERENCES_FILTER_CRITERIA = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECK_REFERENCES_FILTER_CRITERIA);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "check-references-scope-criteria");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "check-references-scope-criteria"));
        provider = new DefinedDefaultBehaviorProvider("global");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CheckReferencesScopeCriteria.class);
        PD_CHECK_REFERENCES_SCOPE_CRITERIA = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECK_REFERENCES_SCOPE_CRITERIA);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.plugins.ReferentialIntegrityPlugin");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.plugin.DirectoryServerPlugin");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-file"));
        provider = new DefinedDefaultBehaviorProvider("logs/referint");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_LOG_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "plugin-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "plugin-type"));
        provider = new DefinedDefaultBehaviorProvider("postoperationdelete", "postoperationmodifydn", "subordinatemodifydn", "subordinatedelete", "preoperationadd", "preoperationmodify");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(PluginCfgDefn.PluginType.class);
        PD_PLUGIN_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PLUGIN_TYPE);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "update-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "update-interval"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(false);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        PD_UPDATE_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_UPDATE_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class ReferentialIntegrityPluginCfgServerImpl
    implements ReferentialIntegrityPluginCfg {
        private ServerManagedObject<? extends ReferentialIntegrityPluginCfg> impl;
        private final SortedSet<AttributeType> pAttributeType;
        private final SortedSet<DN> pBaseDN;
        private final boolean pCheckReferences;
        private final SortedSet<String> pCheckReferencesFilterCriteria;
        private final CheckReferencesScopeCriteria pCheckReferencesScopeCriteria;
        private final boolean pEnabled;
        private final boolean pInvokeForInternalOperations;
        private final String pJavaClass;
        private final String pLogFile;
        private final SortedSet<PluginCfgDefn.PluginType> pPluginType;
        private final long pUpdateInterval;

        private ReferentialIntegrityPluginCfgServerImpl(ServerManagedObject<? extends ReferentialIntegrityPluginCfg> impl) {
            this.impl = impl;
            this.pAttributeType = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAttributeTypePropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pCheckReferences = impl.getPropertyValue(INSTANCE.getCheckReferencesPropertyDefinition());
            this.pCheckReferencesFilterCriteria = impl.getPropertyValues((PropertyDefinition)INSTANCE.getCheckReferencesFilterCriteriaPropertyDefinition());
            this.pCheckReferencesScopeCriteria = impl.getPropertyValue(INSTANCE.getCheckReferencesScopeCriteriaPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pInvokeForInternalOperations = impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogFile = impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
            this.pPluginType = impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
            this.pUpdateInterval = impl.getPropertyValue(INSTANCE.getUpdateIntervalPropertyDefinition());
        }

        @Override
        public void addReferentialIntegrityChangeListener(ConfigurationChangeListener<ReferentialIntegrityPluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeReferentialIntegrityChangeListener(ConfigurationChangeListener<ReferentialIntegrityPluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AttributeType> getAttributeType() {
            return this.pAttributeType;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isCheckReferences() {
            return this.pCheckReferences;
        }

        @Override
        public SortedSet<String> getCheckReferencesFilterCriteria() {
            return this.pCheckReferencesFilterCriteria;
        }

        @Override
        public CheckReferencesScopeCriteria getCheckReferencesScopeCriteria() {
            return this.pCheckReferencesScopeCriteria;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.pInvokeForInternalOperations;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLogFile() {
            return this.pLogFile;
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.pPluginType;
        }

        @Override
        public long getUpdateInterval() {
            return this.pUpdateInterval;
        }

        @Override
        public Class<? extends ReferentialIntegrityPluginCfg> configurationClass() {
            return ReferentialIntegrityPluginCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ReferentialIntegrityPluginCfgClientImpl
    implements ReferentialIntegrityPluginCfgClient {
        private ManagedObject<? extends ReferentialIntegrityPluginCfgClient> impl;

        private ReferentialIntegrityPluginCfgClientImpl(ManagedObject<? extends ReferentialIntegrityPluginCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AttributeType> getAttributeType() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getAttributeTypePropertyDefinition());
        }

        @Override
        public void setAttributeType(Collection<AttributeType> values) {
            this.impl.setPropertyValues(INSTANCE.getAttributeTypePropertyDefinition(), values);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public boolean isCheckReferences() {
            return this.impl.getPropertyValue(INSTANCE.getCheckReferencesPropertyDefinition());
        }

        @Override
        public void setCheckReferences(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCheckReferencesPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getCheckReferencesFilterCriteria() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getCheckReferencesFilterCriteriaPropertyDefinition());
        }

        @Override
        public void setCheckReferencesFilterCriteria(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getCheckReferencesFilterCriteriaPropertyDefinition(), values);
        }

        @Override
        public CheckReferencesScopeCriteria getCheckReferencesScopeCriteria() {
            return this.impl.getPropertyValue(INSTANCE.getCheckReferencesScopeCriteriaPropertyDefinition());
        }

        @Override
        public void setCheckReferencesScopeCriteria(CheckReferencesScopeCriteria value) {
            this.impl.setPropertyValue(INSTANCE.getCheckReferencesScopeCriteriaPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
        }

        @Override
        public void setInvokeForInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLogFile() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
        }

        @Override
        public void setLogFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePropertyDefinition(), value);
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
        }

        @Override
        public void setPluginType(Collection<PluginCfgDefn.PluginType> values) {
            this.impl.setPropertyValues(INSTANCE.getPluginTypePropertyDefinition(), values);
        }

        @Override
        public long getUpdateInterval() {
            return this.impl.getPropertyValue(INSTANCE.getUpdateIntervalPropertyDefinition());
        }

        @Override
        public void setUpdateInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getUpdateIntervalPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ReferentialIntegrityPluginCfgClient, ? extends ReferentialIntegrityPluginCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum CheckReferencesScopeCriteria {
        GLOBAL("global"),
        NAMING_CONTEXT("naming-context");

        private final String name;

        private CheckReferencesScopeCriteria(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

