/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RandomPasswordGeneratorCfgClient;
import org.forgerock.opendj.server.config.meta.PasswordGeneratorCfgDefn;
import org.forgerock.opendj.server.config.server.PasswordGeneratorCfg;
import org.forgerock.opendj.server.config.server.RandomPasswordGeneratorCfg;

public final class RandomPasswordGeneratorCfgDefn
extends ManagedObjectDefinition<RandomPasswordGeneratorCfgClient, RandomPasswordGeneratorCfg> {
    private static final RandomPasswordGeneratorCfgDefn INSTANCE = new RandomPasswordGeneratorCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_PASSWORD_CHARACTER_SET;
    private static final StringPropertyDefinition PD_PASSWORD_FORMAT;

    public static RandomPasswordGeneratorCfgDefn getInstance() {
        return INSTANCE;
    }

    private RandomPasswordGeneratorCfgDefn() {
        super("random-password-generator", PasswordGeneratorCfgDefn.getInstance());
    }

    @Override
    public RandomPasswordGeneratorCfgClient createClientConfiguration(ManagedObject<? extends RandomPasswordGeneratorCfgClient> impl) {
        return new RandomPasswordGeneratorCfgClientImpl(impl);
    }

    @Override
    public RandomPasswordGeneratorCfg createServerConfiguration(ServerManagedObject<? extends RandomPasswordGeneratorCfg> impl) {
        return new RandomPasswordGeneratorCfgServerImpl(impl);
    }

    @Override
    public Class<RandomPasswordGeneratorCfg> getServerConfigurationClass() {
        return RandomPasswordGeneratorCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordGeneratorCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getPasswordCharacterSetPropertyDefinition() {
        return PD_PASSWORD_CHARACTER_SET;
    }

    public StringPropertyDefinition getPasswordFormatPropertyDefinition() {
        return PD_PASSWORD_FORMAT;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.RandomPasswordGenerator");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordGenerator");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "password-character-set");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-character-set"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FORMAT");
        PD_PASSWORD_CHARACTER_SET = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_CHARACTER_SET);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "password-format");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-format"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FORMAT");
        PD_PASSWORD_FORMAT = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_FORMAT);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class RandomPasswordGeneratorCfgServerImpl
    implements RandomPasswordGeneratorCfg {
        private ServerManagedObject<? extends RandomPasswordGeneratorCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final SortedSet<String> pPasswordCharacterSet;
        private final String pPasswordFormat;

        private RandomPasswordGeneratorCfgServerImpl(ServerManagedObject<? extends RandomPasswordGeneratorCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pPasswordCharacterSet = impl.getPropertyValues((PropertyDefinition)INSTANCE.getPasswordCharacterSetPropertyDefinition());
            this.pPasswordFormat = impl.getPropertyValue(INSTANCE.getPasswordFormatPropertyDefinition());
        }

        @Override
        public void addRandomChangeListener(ConfigurationChangeListener<RandomPasswordGeneratorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeRandomChangeListener(ConfigurationChangeListener<RandomPasswordGeneratorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordGeneratorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordGeneratorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<String> getPasswordCharacterSet() {
            return this.pPasswordCharacterSet;
        }

        @Override
        public String getPasswordFormat() {
            return this.pPasswordFormat;
        }

        @Override
        public Class<? extends RandomPasswordGeneratorCfg> configurationClass() {
            return RandomPasswordGeneratorCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class RandomPasswordGeneratorCfgClientImpl
    implements RandomPasswordGeneratorCfgClient {
        private ManagedObject<? extends RandomPasswordGeneratorCfgClient> impl;

        private RandomPasswordGeneratorCfgClientImpl(ManagedObject<? extends RandomPasswordGeneratorCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getPasswordCharacterSet() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getPasswordCharacterSetPropertyDefinition());
        }

        @Override
        public void setPasswordCharacterSet(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getPasswordCharacterSetPropertyDefinition(), values);
        }

        @Override
        public String getPasswordFormat() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordFormatPropertyDefinition());
        }

        @Override
        public void setPasswordFormat(String value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordFormatPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends RandomPasswordGeneratorCfgClient, ? extends RandomPasswordGeneratorCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

