/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.JsonFileHTTPAccessLogPublisherCfgClient;
import org.forgerock.opendj.server.config.client.LogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.client.LogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPAccessLogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPAccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.JsonFileHTTPAccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;

public final class JsonFileHTTPAccessLogPublisherCfgDefn
extends ManagedObjectDefinition<JsonFileHTTPAccessLogPublisherCfgClient, JsonFileHTTPAccessLogPublisherCfg> {
    private static final JsonFileHTTPAccessLogPublisherCfgDefn INSTANCE = new JsonFileHTTPAccessLogPublisherCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LOG_DIRECTORY;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;

    public static JsonFileHTTPAccessLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private JsonFileHTTPAccessLogPublisherCfgDefn() {
        super("json-file-http-access-log-publisher", HTTPAccessLogPublisherCfgDefn.getInstance());
    }

    @Override
    public JsonFileHTTPAccessLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends JsonFileHTTPAccessLogPublisherCfgClient> impl) {
        return new JsonFileHTTPAccessLogPublisherCfgClientImpl(impl);
    }

    @Override
    public JsonFileHTTPAccessLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends JsonFileHTTPAccessLogPublisherCfg> impl) {
        return new JsonFileHTTPAccessLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<JsonFileHTTPAccessLogPublisherCfg> getServerConfigurationClass() {
        return JsonFileHTTPAccessLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPAccessLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLogDirectoryPropertyDefinition() {
        return PD_LOG_DIRECTORY;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.CommonAuditHTTPAccessLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-directory"));
        provider = new DefinedDefaultBehaviorProvider("logs");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DIRECTORY");
        PD_LOG_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_DIRECTORY);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class JsonFileHTTPAccessLogPublisherCfgServerImpl
    implements JsonFileHTTPAccessLogPublisherCfg {
        private ServerManagedObject<? extends JsonFileHTTPAccessLogPublisherCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pLogDirectory;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;

        private JsonFileHTTPAccessLogPublisherCfgServerImpl(ServerManagedObject<? extends JsonFileHTTPAccessLogPublisherCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogDirectory = impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void addJsonFileHTTPAccessChangeListener(ConfigurationChangeListener<JsonFileHTTPAccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeJsonFileHTTPAccessChangeListener(ConfigurationChangeListener<JsonFileHTTPAccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addHTTPAccessChangeListener(ConfigurationChangeListener<HTTPAccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeHTTPAccessChangeListener(ConfigurationChangeListener<HTTPAccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLogDirectory() {
            return this.pLogDirectory;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public Class<? extends JsonFileHTTPAccessLogPublisherCfg> configurationClass() {
            return JsonFileHTTPAccessLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class JsonFileHTTPAccessLogPublisherCfgClientImpl
    implements JsonFileHTTPAccessLogPublisherCfgClient {
        private ManagedObject<? extends JsonFileHTTPAccessLogPublisherCfgClient> impl;

        private JsonFileHTTPAccessLogPublisherCfgClientImpl(ManagedObject<? extends JsonFileHTTPAccessLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLogDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
        }

        @Override
        public void setLogDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends JsonFileHTTPAccessLogPublisherCfgClient, ? extends JsonFileHTTPAccessLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

