/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.client.BackendIndexCfgClient;
import org.forgerock.opendj.server.config.meta.PluggableBackendCfgDefn;
import org.forgerock.opendj.server.config.server.BackendIndexCfg;

public final class BackendIndexCfgDefn
extends ManagedObjectDefinition<BackendIndexCfgClient, BackendIndexCfg> {
    private static final BackendIndexCfgDefn INSTANCE = new BackendIndexCfgDefn();
    private static final AttributeTypePropertyDefinition PD_ATTRIBUTE;
    private static final BooleanPropertyDefinition PD_CONFIDENTIALITY_ENABLED;
    private static final IntegerPropertyDefinition PD_INDEX_ENTRY_LIMIT;
    private static final StringPropertyDefinition PD_INDEX_EXTENSIBLE_MATCHING_RULE;
    private static final EnumPropertyDefinition<IndexType> PD_INDEX_TYPE;
    private static final IntegerPropertyDefinition PD_SUBSTRING_LENGTH;

    public static BackendIndexCfgDefn getInstance() {
        return INSTANCE;
    }

    private BackendIndexCfgDefn() {
        super("backend-index", TopCfgDefn.getInstance());
    }

    @Override
    public BackendIndexCfgClient createClientConfiguration(ManagedObject<? extends BackendIndexCfgClient> impl) {
        return new BackendIndexCfgClientImpl(impl);
    }

    @Override
    public BackendIndexCfg createServerConfiguration(ServerManagedObject<? extends BackendIndexCfg> impl) {
        return new BackendIndexCfgServerImpl(impl);
    }

    @Override
    public Class<BackendIndexCfg> getServerConfigurationClass() {
        return BackendIndexCfg.class;
    }

    public AttributeTypePropertyDefinition getAttributePropertyDefinition() {
        return PD_ATTRIBUTE;
    }

    public BooleanPropertyDefinition getConfidentialityEnabledPropertyDefinition() {
        return PD_CONFIDENTIALITY_ENABLED;
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PD_INDEX_ENTRY_LIMIT;
    }

    public StringPropertyDefinition getIndexExtensibleMatchingRulePropertyDefinition() {
        return PD_INDEX_EXTENSIBLE_MATCHING_RULE;
    }

    public EnumPropertyDefinition<IndexType> getIndexTypePropertyDefinition() {
        return PD_INDEX_TYPE;
    }

    public IntegerPropertyDefinition getSubstringLengthPropertyDefinition() {
        return PD_SUBSTRING_LENGTH;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "attribute");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ATTRIBUTE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "confidentiality-enabled");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "confidentiality-enabled"));
        DefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_CONFIDENTIALITY_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONFIDENTIALITY_ENABLED);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-entry-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-entry-limit"));
        provider = new RelativeInheritedDefaultBehaviorProvider(PluggableBackendCfgDefn.getInstance(), "index-entry-limit", 1);
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ENTRY_LIMIT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "index-extensible-matching-rule");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-extensible-matching-rule"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "index-extensible-matching-rule"));
        ((StringPropertyDefinition.Builder)builder).setPattern("([a-z][a-z](-[A-Z][A-Z]){0,2}(.(([a-z]{2,3})|\\d))?)|(^\\d.((\\d)+.)+\\d$)", "LOCALE | OID");
        PD_INDEX_EXTENSIBLE_MATCHING_RULE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_EXTENSIBLE_MATCHING_RULE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "index-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(IndexType.class);
        PD_INDEX_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_TYPE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "substring-length");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "substring-length"));
        provider = new DefinedDefaultBehaviorProvider("6");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(3);
        PD_SUBSTRING_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SUBSTRING_LENGTH);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class BackendIndexCfgServerImpl
    implements BackendIndexCfg {
        private ServerManagedObject<? extends BackendIndexCfg> impl;
        private final AttributeType pAttribute;
        private final boolean pConfidentialityEnabled;
        private final Integer pIndexEntryLimit;
        private final SortedSet<String> pIndexExtensibleMatchingRule;
        private final SortedSet<IndexType> pIndexType;
        private final int pSubstringLength;

        private BackendIndexCfgServerImpl(ServerManagedObject<? extends BackendIndexCfg> impl) {
            this.impl = impl;
            this.pAttribute = impl.getPropertyValue(INSTANCE.getAttributePropertyDefinition());
            this.pConfidentialityEnabled = impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
            this.pIndexEntryLimit = impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
            this.pIndexExtensibleMatchingRule = impl.getPropertyValues((PropertyDefinition)INSTANCE.getIndexExtensibleMatchingRulePropertyDefinition());
            this.pIndexType = impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
            this.pSubstringLength = impl.getPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendIndexCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendIndexCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getAttribute() {
            return this.pAttribute;
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.pConfidentialityEnabled;
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.pIndexEntryLimit;
        }

        @Override
        public SortedSet<String> getIndexExtensibleMatchingRule() {
            return this.pIndexExtensibleMatchingRule;
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.pIndexType;
        }

        @Override
        public int getSubstringLength() {
            return this.pSubstringLength;
        }

        @Override
        public Class<? extends BackendIndexCfg> configurationClass() {
            return BackendIndexCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class BackendIndexCfgClientImpl
    implements BackendIndexCfgClient {
        private ManagedObject<? extends BackendIndexCfgClient> impl;

        private BackendIndexCfgClientImpl(ManagedObject<? extends BackendIndexCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getAttributePropertyDefinition());
        }

        @Override
        public void setAttribute(AttributeType value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getAttributePropertyDefinition(), value);
        }

        @Override
        public boolean isConfidentialityEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition());
        }

        @Override
        public void setConfidentialityEnabled(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getConfidentialityEnabledPropertyDefinition(), value);
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getIndexExtensibleMatchingRule() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getIndexExtensibleMatchingRulePropertyDefinition());
        }

        @Override
        public void setIndexExtensibleMatchingRule(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getIndexExtensibleMatchingRulePropertyDefinition(), values);
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
        }

        @Override
        public void setIndexType(Collection<IndexType> values) {
            this.impl.setPropertyValues(INSTANCE.getIndexTypePropertyDefinition(), values);
        }

        @Override
        public int getSubstringLength() {
            return this.impl.getPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition());
        }

        @Override
        public void setSubstringLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getSubstringLengthPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends BackendIndexCfgClient, ? extends BackendIndexCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum IndexType {
        APPROXIMATE("approximate"),
        EQUALITY("equality"),
        EXTENSIBLE("extensible"),
        ORDERING("ordering"),
        PRESENCE("presence"),
        SUBSTRING("substring");

        private final String name;

        private IndexType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

