/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.server.AbstractConfigListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.DNBuilder;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectAddListener;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.config.server.spi.ConfigAddListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigAddListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigAddListener {
    private static final Logger debugLogger = LoggerFactory.getLogger(ConfigAddListenerAdaptor.class);
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final InstantiableRelationDefinition<?, S> instantiableRelation;
    private final SetRelationDefinition<?, S> setRelation;
    private final ServerManagedObjectAddListener<S> listener;
    private final OptionalRelationDefinition<?, S> optionalRelation;
    private final ManagedObjectPath<?, ?> path;
    private final ServerManagementContext serverContext;

    public ConfigAddListenerAdaptor(ServerManagementContext context, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.serverContext = context;
        this.path = path;
        this.instantiableRelation = relation;
        this.optionalRelation = null;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigAddListenerAdaptor(ServerManagementContext context, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.serverContext = context;
        this.path = path;
        this.optionalRelation = relation;
        this.instantiableRelation = null;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigAddListenerAdaptor(ServerManagementContext context, ManagedObjectPath<?, ?> path, SetRelationDefinition<?, S> relation, ServerManagedObjectAddListener<S> listener) {
        this.serverContext = context;
        this.path = path;
        this.instantiableRelation = null;
        this.optionalRelation = null;
        this.setRelation = relation;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(Entry configEntry) {
        ConfigChangeResult result;
        if (this.optionalRelation != null) {
            ManagedObjectPath<?, S> childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!configEntry.getName().equals((Object)expectedDN)) {
                return new ConfigChangeResult();
            }
        }
        if ((result = this.listener.applyConfigurationAdd(this.cachedManagedObject)).getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostAdd(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        debugLogger.trace("Unable to perform post add", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configAddIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
        DN dn = configEntry.getName();
        String name = dn.rdn().getFirstAVA().getAttributeValue().toString().trim();
        try {
            ManagedObjectPath<?, S> childPath;
            if (this.instantiableRelation != null) {
                childPath = this.path.child(this.instantiableRelation, name);
            } else if (this.setRelation != null) {
                try {
                    childPath = this.path.child(this.setRelation, name);
                }
                catch (IllegalArgumentException e) {
                    throw new DefinitionDecodingException(this.setRelation.getChildDefinition(), DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
                }
            } else {
                childPath = this.path.child(this.optionalRelation);
                DN expectedDN = DNBuilder.create(childPath);
                if (!dn.equals((Object)expectedDN)) {
                    return true;
                }
            }
            this.cachedManagedObject = this.serverContext.decode(childPath, configEntry, configEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        try {
            this.cachedManagedObject.ensureIsUsable();
        }
        catch (ConstraintViolationException e) {
            this.generateUnacceptableReason(e.getMessages(), unacceptableReason);
            return false;
        }
        LinkedList<LocalizableMessage> reasons = new LinkedList<LocalizableMessage>();
        if (this.listener.isConfigurationAddAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ServerManagedObjectAddListener<S> getServerManagedObjectAddListener() {
        return this.listener;
    }
}

