/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.text.NumberFormat;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.DurationUnit;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.SizeUnit;

final class PropertyValuePrinter {
    private final MyPropertyValueVisitor pimpl;

    public PropertyValuePrinter(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
        this.pimpl = new MyPropertyValueVisitor(sizeUnit, timeUnit, isScriptFriendly);
    }

    public <T> LocalizableMessage print(PropertyDefinition<T> pd, T value) {
        return pd.accept(this.pimpl, value, null);
    }

    private static final class MyPropertyValueVisitor
    extends PropertyValueVisitor<LocalizableMessage, Void> {
        private final SizeUnit sizeUnit;
        private final DurationUnit timeUnit;
        private final boolean isScriptFriendly;
        private final NumberFormat numberFormat;

        private MyPropertyValueVisitor(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
            this.sizeUnit = sizeUnit;
            this.timeUnit = timeUnit;
            this.isScriptFriendly = isScriptFriendly;
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setGroupingUsed(!this.isScriptFriendly);
            this.numberFormat.setMaximumFractionDigits(2);
        }

        @Override
        public LocalizableMessage visitBoolean(BooleanPropertyDefinition pd, Boolean v, Void p) {
            return v != false ? DsconfigMessages.INFO_VALUE_TRUE.get() : DsconfigMessages.INFO_VALUE_FALSE.get();
        }

        @Override
        public LocalizableMessage visitDuration(DurationPropertyDefinition pd, Long v, Void p) {
            if (pd.getUpperLimit() == null && (v < 0L || v == Long.MAX_VALUE)) {
                return DsconfigMessages.INFO_VALUE_UNLIMITED.get();
            }
            LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
            long ms = pd.getBaseUnit().toMilliSeconds(v.longValue());
            if (this.timeUnit == null && !this.isScriptFriendly && ms != 0L) {
                builder.append((CharSequence)DurationUnit.toString(ms));
            } else {
                DurationUnit unit = this.timeUnit;
                if (unit == null) {
                    unit = pd.getBaseUnit();
                }
                builder.append((CharSequence)this.numberFormat.format(unit.fromMilliSeconds(ms)));
                builder.append(' ');
                builder.append((CharSequence)unit.getShortName());
            }
            return builder.toMessage();
        }

        @Override
        public LocalizableMessage visitSize(SizePropertyDefinition pd, Long v, Void p) {
            if (pd.isAllowUnlimited() && v < 0L) {
                return DsconfigMessages.INFO_VALUE_UNLIMITED.get();
            }
            SizeUnit unit = this.sizeUnit;
            if (unit == null) {
                unit = this.isScriptFriendly ? SizeUnit.getBestFitUnitExact(v) : SizeUnit.getBestFitUnit(v);
            }
            LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
            builder.append((CharSequence)this.numberFormat.format(unit.fromBytes(v)));
            builder.append(' ');
            builder.append((CharSequence)unit.getShortName());
            return builder.toMessage();
        }

        @Override
        public <T> LocalizableMessage visitUnknown(PropertyDefinition<T> pd, T v, Void p) {
            String s = pd.encodeValue(v);
            if (this.isScriptFriendly) {
                return LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{s});
            }
            if (s.trim().length() == 0 || s.contains(",")) {
                return LocalizableMessage.raw((CharSequence)"\"%s\"", (Object[])new Object[]{s});
            }
            return LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{s});
        }
    }
}

