/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.PropertyValuePrinter;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;

final class HelpSubCommandHandler
extends SubCommandHandler {
    private static final String HEADING_SEPARATOR = " : ";
    private static final int HEADING_WIDTH;
    private static final String OPTION_DSCFG_LONG_CATEGORY = "category";
    private static final String OPTION_DSCFG_LONG_INHERITED = "inherited";
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_CATEGORY;
    private static final Character OPTION_DSCFG_SHORT_INHERITED;
    private static final Character OPTION_DSCFG_SHORT_TYPE;
    private final SubCommand subCommand;
    private final StringArgument categoryArgument;
    private final Map<String, Map<String, AbstractManagedObjectDefinition<?, ?>>> categoryMap = new TreeMap();
    private final BooleanArgument inheritedModeArgument;
    private final Map<Tag, Map<String, AbstractManagedObjectDefinition<?, ?>>> tagMap = new HashMap();
    private final StringArgument typeArgument;

    public static HelpSubCommandHandler create(SubCommandArgumentParser parser) throws ArgumentException {
        return new HelpSubCommandHandler(parser);
    }

    public static void displaySingleComponent(ConsoleApplication app, ManagedObject<?> mo, Collection<PropertyDefinition<?>> c) {
        String ufn = mo.getManagedObjectPath().getName();
        if (ufn == null) {
            ufn = mo.getManagedObjectDefinition().getUserFriendlyName().toString();
        }
        app.println(DsconfigMessages.INFO_DSCFG_HELP_HEADING_COMPONENT.get((Object)ufn));
        ManagedObjectDefinition<?, Configuration> d = mo.getManagedObjectDefinition();
        app.println();
        app.println(d.getSynopsis());
        if (d.getDescription() != null) {
            app.println();
            app.println(d.getDescription());
        }
        app.println();
        app.println();
        HelpSubCommandHandler.displayPropertyOptionKey(app);
        app.println();
        app.println();
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_OPTIONS.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        builder.addSortKey(0);
        for (PropertyDefinition<?> pd : c) {
            builder.startRow();
            builder.appendCell((Object)pd.getName());
            builder.appendCell((Object)HelpSubCommandHandler.getPropertyOptionSummary(pd));
            PropertyDefinitionUsageBuilder v = new PropertyDefinitionUsageBuilder(false);
            builder.appendCell((Object)v.getUsage(pd));
        }
        builder.print((TablePrinter)new TextTablePrinter((OutputStream)app.getErrorStream()));
    }

    public static void displayVerboseSingleProperty(ConsoleApplication app, AbstractManagedObjectDefinition<?, ?> d, String name) {
        AggregationPropertyDefinition apd;
        PropertyDefinition<?> pd = d.getPropertyDefinition(name);
        app.println(DsconfigMessages.INFO_DSCFG_HELP_HEADING_PROPERTY.get((Object)name));
        app.println();
        app.println(pd.getSynopsis(), 4);
        if (pd.getDescription() != null) {
            app.println();
            app.println(pd.getDescription(), 4);
        }
        if (pd instanceof AggregationPropertyDefinition && (apd = (AggregationPropertyDefinition)pd).getSourceConstraintSynopsis() != null) {
            app.println();
            app.println(apd.getSourceConstraintSynopsis(), 4);
        }
        app.println();
        SyntaxPrinter syntaxPrinter = new SyntaxPrinter();
        syntaxPrinter.print(app.getErrorStream(), pd);
        app.println();
        TableBuilder builder = new TableBuilder();
        DefaultBehaviorPrinter defaultPrinter = new DefaultBehaviorPrinter();
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_DEFAULT.get());
        builder.appendCell((Object)HEADING_SEPARATOR);
        builder.appendCell((Object)defaultPrinter.print(pd));
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_ADVANCED.get());
        builder.appendCell((Object)HEADING_SEPARATOR);
        builder.appendCell((Object)HelpSubCommandHandler.hasOptionYN(pd, PropertyOption.ADVANCED));
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_MULTI_VALUED.get());
        builder.appendCell((Object)HEADING_SEPARATOR);
        builder.appendCell((Object)HelpSubCommandHandler.hasOptionYN(pd, PropertyOption.MULTI_VALUED));
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_MANDATORY.get());
        builder.appendCell((Object)HEADING_SEPARATOR);
        builder.appendCell((Object)HelpSubCommandHandler.hasOptionYN(pd, PropertyOption.MANDATORY));
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_READ_ONLY.get());
        builder.appendCell((Object)HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MONITORING)) {
            builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_FIELD_MONITORING.get());
        } else if (pd.hasOption(PropertyOption.READ_ONLY)) {
            builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_FIELD_READ_ONLY.get((Object)d.getUserFriendlyName()));
        } else {
            builder.appendCell((Object)CliMessages.INFO_GENERAL_NO.get());
        }
        TextTablePrinter factory = new TextTablePrinter((OutputStream)app.getErrorStream());
        factory.setDisplayHeadings(false);
        factory.setColumnWidth(0, HEADING_WIDTH);
        factory.setColumnWidth(2, 0);
        factory.setPadding(0);
        builder.print((TablePrinter)factory);
        LocalizableMessage synopsis = HelpSubCommandHandler.getSynopsis(d, pd);
        if (synopsis != null) {
            app.println();
            app.println(synopsis);
        }
    }

    private static LocalizableMessage hasOptionYN(PropertyDefinition<?> pd, PropertyOption option) {
        return pd.hasOption(option) ? CliMessages.INFO_GENERAL_YES.get() : CliMessages.INFO_GENERAL_NO.get();
    }

    private static LocalizableMessage getSynopsis(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        AdministratorAction action = pd.getAdministratorAction();
        LocalizableMessage synopsis = action.getSynopsis();
        if (synopsis != null) {
            return synopsis;
        }
        switch (action.getType()) {
            case COMPONENT_RESTART: {
                return DsconfigMessages.INFO_DSCFG_HELP_FIELD_COMPONENT_RESTART.get((Object)d.getUserFriendlyName());
            }
            case SERVER_RESTART: {
                return DsconfigMessages.INFO_DSCFG_HELP_FIELD_SERVER_RESTART.get();
            }
        }
        return null;
    }

    private static void displayPropertyOptionKey(ConsoleApplication app) {
        app.println(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_OPTION.get());
        app.println();
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        builder.append((CharSequence)" r -- ");
        builder.append(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_READ.get());
        app.println(builder.toMessage());
        builder = new LocalizableMessageBuilder();
        builder.append((CharSequence)" w -- ");
        builder.append(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_WRITE.get());
        app.println(builder.toMessage());
        builder = new LocalizableMessageBuilder();
        builder.append((CharSequence)" m -- ");
        builder.append(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_MANDATORY.get());
        app.println(builder.toMessage());
        builder = new LocalizableMessageBuilder();
        builder.append((CharSequence)" s -- ");
        builder.append(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_SINGLE_VALUED.get());
        app.println(builder.toMessage());
        builder = new LocalizableMessageBuilder();
        builder.append((CharSequence)" a -- ");
        builder.append(DsconfigMessages.INFO_DSCFG_HELP_DESCRIPTION_ADMIN_ACTION.get());
        app.println(builder.toMessage());
    }

    private static String getPropertyOptionSummary(PropertyDefinition<?> pd) {
        StringBuilder b = new StringBuilder();
        if (pd.hasOption(PropertyOption.MONITORING) || pd.hasOption(PropertyOption.READ_ONLY)) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            b.append('-');
        } else {
            b.append('s');
        }
        AdministratorAction action = pd.getAdministratorAction();
        if (action.getType() != AdministratorAction.Type.NONE) {
            b.append('a');
        } else {
            b.append('-');
        }
        return b.toString();
    }

    private HelpSubCommandHandler(SubCommandArgumentParser parser) throws ArgumentException {
        String name = "list-properties";
        LocalizableMessage desc = DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_HELPPROP.get();
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, desc);
        this.categoryArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_CATEGORY).shortIdentifier(OPTION_DSCFG_SHORT_CATEGORY)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_HELP_CATEGORY.get())).valuePlaceholder(DsconfigMessages.INFO_CATEGORY_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.typeArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_TYPE).shortIdentifier(OPTION_DSCFG_SHORT_TYPE)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_HELP_TYPE.get())).valuePlaceholder(DsconfigMessages.INFO_TYPE_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        this.inheritedModeArgument = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)OPTION_DSCFG_LONG_INHERITED).shortIdentifier(OPTION_DSCFG_SHORT_INHERITED)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_HELP_INHERITED.get())).buildAndAddToSubCommand(this.subCommand);
        this.registerPropertyNameArgument(this.subCommand);
        this.setCommandBuilderUseful(false);
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public void registerManagedObjectDefinition(AbstractManagedObjectDefinition<?, ?> d) {
        AbstractManagedObjectDefinition<?, ?> parent = d;
        while (!parent.getParent().isTop()) {
            parent = parent.getParent();
        }
        String baseName = parent.getName();
        String typeName = null;
        if (parent == d) {
            typeName = "generic";
        } else {
            String suffix = "-" + baseName;
            typeName = d.getName();
            if (typeName.endsWith(suffix)) {
                typeName = typeName.substring(0, typeName.length() - suffix.length());
            }
        }
        Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(baseName);
        if (subTypes == null) {
            subTypes = new TreeMap();
            this.categoryMap.put(baseName, subTypes);
        }
        subTypes.put(typeName, d);
        for (Tag tag : d.getAllTags()) {
            subTypes = this.tagMap.get(tag);
            if (subTypes == null) {
                subTypes = new TreeMap();
                this.tagMap.put(tag, subTypes);
            }
            subTypes.put(typeName, d);
        }
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        String categoryName = this.categoryArgument.getValue();
        String typeName = this.typeArgument.getValue();
        Tag tag = null;
        Set<String> propertyNames = this.getPropertyNames();
        this.getCommandBuilder().clearArguments();
        this.updateCommandBuilderWithSubCommand();
        LinkedList<Object> dlist = new LinkedList<Object>();
        Object tmp = null;
        if (categoryName != null) {
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(categoryName);
            if (subTypes == null) {
                try {
                    tag = Tag.valueOf(categoryName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
                subTypes = this.tagMap.get(tag);
                if (subTypes == null) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
            } else {
                tmp = subTypes.get("generic");
            }
            if (typeName != null) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) {
                    throw ArgumentExceptionFactory.unknownTypeForCategory(typeName, categoryName);
                }
                dlist.add(d);
                tmp = d;
            } else {
                dlist.addAll(subTypes.values());
            }
        } else if (typeName != null) {
            boolean isFound = false;
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) continue;
                dlist.add(d);
                isFound = true;
            }
            if (!isFound) {
                throw ArgumentExceptionFactory.unknownTypeForCategory(typeName, categoryName);
            }
        } else {
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                dlist.addAll(subTypes.values());
            }
        }
        if (dlist.size() == 1) {
            tmp = (AbstractManagedObjectDefinition)dlist.get(0);
        }
        for (String propertyName : propertyNames) {
            boolean isFound = false;
            for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : dlist) {
                try {
                    abstractManagedObjectDefinition.getPropertyDefinition(propertyName);
                    isFound = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (isFound) continue;
            if (tmp != null) {
                throw ArgumentExceptionFactory.unknownProperty(tmp, propertyName);
            }
            throw ArgumentExceptionFactory.unknownProperty(propertyName);
        }
        if (!app.isVerbose()) {
            this.displayNonVerbose(app, categoryName, typeName, tag, propertyNames);
        } else {
            this.displayVerbose(app, categoryName, typeName, tag, propertyNames);
        }
        return MenuResult.success((Object)0);
    }

    private void displayNonVerbose(ConsoleApplication app, String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        if (!app.isScriptFriendly()) {
            HelpSubCommandHandler.displayPropertyOptionKey(app);
            app.println();
            app.println();
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_COMPONENT_NAME.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_COMPONENT_TYPE.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_OPTIONS.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        builder.addSortKey(0);
        builder.addSortKey(1);
        builder.addSortKey(2);
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                AbstractManagedObjectDefinition<?, ?> mod;
                if (typeName != null && !typeName.equals(type) || HelpSubCommandHandler.cannotDisplay(app, mod = subTypes.get(type), tag)) continue;
                Set<PropertyDefinition<?>> pds = this.getPropertyDefinitions(mod);
                for (PropertyDefinition<?> pd : pds) {
                    if (HelpSubCommandHandler.cannotDisplay(app, pd, propertyNames)) continue;
                    builder.startRow();
                    builder.appendCell((Object)category);
                    builder.appendCell((Object)type);
                    builder.appendCell((Object)pd.getName());
                    builder.appendCell((Object)HelpSubCommandHandler.getPropertyOptionSummary(pd));
                    PropertyDefinitionUsageBuilder v = new PropertyDefinitionUsageBuilder(false);
                    builder.appendCell((Object)v.getUsage(pd));
                }
            }
        }
        Object printer = app.isScriptFriendly() ? this.createScriptFriendlyTablePrinter(app.getOutputStream()) : new TextTablePrinter((OutputStream)app.getOutputStream());
        builder.print(printer);
    }

    private void displayVerbose(ConsoleApplication app, String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        LocalizableMessage c1 = this.buildLine('=', Utils.MAX_LINE_WIDTH);
        LocalizableMessage c2 = this.buildLine('-', Utils.MAX_LINE_WIDTH);
        boolean isFirstManagedObject = true;
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                AbstractManagedObjectDefinition<?, ?> mod;
                if (typeName != null && !typeName.equals(type) || HelpSubCommandHandler.cannotDisplay(app, mod = subTypes.get(type), tag)) continue;
                boolean isFirstProperty = true;
                Set<PropertyDefinition<?>> pds = this.getPropertyDefinitions(mod);
                for (PropertyDefinition<?> pd : pds) {
                    if (HelpSubCommandHandler.cannotDisplay(app, pd, propertyNames)) continue;
                    if (isFirstProperty) {
                        if (!isFirstManagedObject) {
                            app.println();
                            app.println(c1);
                            app.println();
                        } else {
                            isFirstManagedObject = false;
                        }
                        app.println(DsconfigMessages.INFO_DSCFG_HELP_HEADING_COMPONENT.get((Object)mod.getUserFriendlyName()));
                        app.println();
                        app.println(mod.getSynopsis());
                        if (mod.getDescription() != null) {
                            app.println();
                            app.println(mod.getDescription());
                        }
                    }
                    app.println();
                    app.println(c2);
                    app.println();
                    HelpSubCommandHandler.displayVerboseSingleProperty(app, mod, pd.getName());
                    isFirstProperty = false;
                }
            }
        }
    }

    private LocalizableMessage buildLine(char c, int length) {
        LocalizableMessageBuilder mb = new LocalizableMessageBuilder();
        for (int i = 0; i < length; ++i) {
            mb.append(c);
        }
        return mb.toMessage();
    }

    private Set<PropertyDefinition<?>> getPropertyDefinitions(AbstractManagedObjectDefinition<?, ?> mod) {
        TreeSet pds = new TreeSet();
        if (this.inheritedModeArgument.isPresent()) {
            pds.addAll(mod.getAllPropertyDefinitions());
        } else {
            pds.addAll(mod.getPropertyDefinitions());
            if (mod.getParent() != null) {
                pds.removeAll(mod.getParent().getAllPropertyDefinitions());
            }
        }
        return pds;
    }

    static {
        OPTION_DSCFG_SHORT_CATEGORY = Character.valueOf('c');
        OPTION_DSCFG_SHORT_INHERITED = null;
        OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
        int tmp = DsconfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get().length();
        tmp = Math.max(tmp, DsconfigMessages.INFO_DSCFG_HELP_HEADING_DEFAULT.get().length());
        tmp = Math.max(tmp, DsconfigMessages.INFO_DSCFG_HELP_HEADING_MULTI_VALUED.get().length());
        tmp = Math.max(tmp, DsconfigMessages.INFO_DSCFG_HELP_HEADING_MANDATORY.get().length());
        HEADING_WIDTH = tmp = Math.max(tmp, DsconfigMessages.INFO_DSCFG_HELP_HEADING_READ_ONLY.get().length());
    }

    private static class SyntaxPrinter {
        private final Visitor pimpl = new Visitor();

        public void print(PrintStream out, PropertyDefinition<?> pd) {
            pd.accept(this.pimpl, out);
        }

        private static final class Visitor
        extends PropertyDefinitionVisitor<Void, PrintStream> {
            private Visitor() {
            }

            @Override
            public <E extends Enum<E>> Void visitEnum(EnumPropertyDefinition<E> d, PrintStream p) {
                this.displayUsage(p, DsconfigMessages.INFO_DSCFG_HELP_FIELD_ENUM.get());
                p.println();
                TableBuilder builder = new TableBuilder();
                boolean isFirst = true;
                for (Enum value : EnumSet.allOf(d.getEnumClass())) {
                    if (!isFirst) {
                        builder.startRow();
                    }
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell((Object)value.toString());
                    builder.appendCell((Object)HelpSubCommandHandler.HEADING_SEPARATOR);
                    builder.appendCell((Object)d.getValueSynopsis(value));
                    isFirst = false;
                }
                TextTablePrinter factory = new TextTablePrinter((OutputStream)p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(1, HelpSubCommandHandler.HEADING_SEPARATOR.length());
                factory.setColumnWidth(4, 0);
                factory.setPadding(0);
                builder.print((TablePrinter)factory);
                return null;
            }

            @Override
            public Void visitString(StringPropertyDefinition d, PrintStream p) {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(false);
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get());
                builder.appendCell((Object)HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell((Object)usageBuilder.getUsage(d));
                if (d.getPattern() != null) {
                    builder.startRow();
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell((Object)d.getPatternSynopsis());
                }
                TextTablePrinter factory = new TextTablePrinter((OutputStream)p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print((TablePrinter)factory);
                return null;
            }

            @Override
            public <T> Void visitUnknown(PropertyDefinition<T> d, PrintStream p) {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(true);
                this.displayUsage(p, usageBuilder.getUsage(d));
                return null;
            }

            private void displayUsage(PrintStream p, LocalizableMessage usage) {
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell((Object)DsconfigMessages.INFO_DSCFG_HELP_HEADING_SYNTAX.get());
                builder.appendCell((Object)HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell((Object)usage);
                TextTablePrinter factory = new TextTablePrinter((OutputStream)p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print((TablePrinter)factory);
            }
        }
    }

    private static class DefaultBehaviorPrinter {
        public <T> LocalizableMessage print(PropertyDefinition<T> pd) {
            DefaultVisitor v = new DefaultVisitor();
            return (LocalizableMessage)pd.getDefaultBehaviorProvider().accept(v, pd);
        }

        private static class DefaultVisitor<T>
        implements DefaultBehaviorProviderVisitor<T, LocalizableMessage, PropertyDefinition<T>> {
            private DefaultVisitor() {
            }

            @Override
            public LocalizableMessage visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return DsconfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_ABS.get((Object)d.getPropertyName(), (Object)d.getManagedObjectPath().getRelationDefinition().getUserFriendlyName());
            }

            @Override
            public LocalizableMessage visitAlias(AliasDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return d.getSynopsis();
            }

            @Override
            public LocalizableMessage visitDefined(DefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
                PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
                boolean isFirst = true;
                for (String s : d.getDefaultValues()) {
                    if (!isFirst) {
                        builder.append((CharSequence)", ");
                    }
                    T value = p.decodeValue(s);
                    builder.append(printer.print(p, value));
                }
                return builder.toMessage();
            }

            @Override
            public LocalizableMessage visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                if (d.getRelativeOffset() == 0) {
                    return DsconfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_THIS.get((Object)d.getPropertyName(), (Object)d.getManagedObjectDefinition().getUserFriendlyName());
                }
                return DsconfigMessages.INFO_DSCFG_HELP_FIELD_INHERITED_PARENT.get((Object)d.getPropertyName(), (Object)d.getManagedObjectDefinition().getUserFriendlyName());
            }

            @Override
            public LocalizableMessage visitUndefined(UndefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return DsconfigMessages.INFO_DSCFG_HELP_FIELD_UNDEFINED.get();
            }
        }
    }
}

