/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.conditions;

import java.util.Collection;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Reject;

public final class IsPresentCondition
implements Condition {
    private final String propertyName;
    private PropertyDefinition<?> pd;

    public IsPresentCondition(String propertyName) {
        Reject.ifNull((Object)propertyName);
        this.propertyName = propertyName;
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
        Collection values = managedObject.getPropertyValues((PropertyDefinition)this.pd);
        return !values.isEmpty();
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        Collection values = managedObject.getPropertyValues((PropertyDefinition)this.pd);
        return !values.isEmpty();
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        this.pd = d.getPropertyDefinition(this.propertyName);
    }
}

