/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.conditions;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.ANDCondition;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.conditions.ContainsCondition;
import org.forgerock.opendj.config.conditions.IsPresentCondition;
import org.forgerock.opendj.config.conditions.NOTCondition;
import org.forgerock.opendj.config.conditions.ORCondition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.LdapException;

public final class Conditions {
    public static final Condition FALSE = new Condition(){

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
            return false;
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            return false;
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }
    };
    public static final Condition TRUE = new Condition(){

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
            return true;
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            return true;
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }
    };

    public static Condition and(Condition ... conditions) {
        return new ANDCondition(conditions);
    }

    public static Condition contains(String propertyName, String propertyStringValue) {
        return new ContainsCondition(propertyName, propertyStringValue);
    }

    public static Condition implies(Condition premise, Condition implication) {
        return Conditions.or(Conditions.not(premise), implication);
    }

    public static Condition isPresent(String propertyName) {
        return new IsPresentCondition(propertyName);
    }

    public static Condition not(Condition condition) {
        return new NOTCondition(condition);
    }

    public static Condition or(Condition ... conditions) {
        return new ORCondition(conditions);
    }

    private Conditions() {
    }
}

