/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.ACIPropertyDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.DurationUnit;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.SizeUnit;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.util.Utils;

public final class PropertyDefinitionUsageBuilder {
    private final MyPropertyDefinitionVisitor pimpl;

    public PropertyDefinitionUsageBuilder(boolean isDetailed) {
        this.pimpl = new MyPropertyDefinitionVisitor(isDetailed);
    }

    public LocalizableMessage getUsage(PropertyDefinition<?> pd) {
        return pd.accept(this.pimpl, null);
    }

    private static final class MyPropertyDefinitionVisitor
    extends PropertyDefinitionVisitor<LocalizableMessage, Void> {
        private final boolean isDetailed;
        private final NumberFormat numberFormat;

        private MyPropertyDefinitionVisitor(boolean isDetailed) {
            this.isDetailed = isDetailed;
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setGroupingUsed(true);
            this.numberFormat.setMaximumFractionDigits(2);
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> LocalizableMessage visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            return LocalizableMessage.raw((CharSequence)"NAME", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitAttributeType(AttributeTypePropertyDefinition d, Void p) {
            return LocalizableMessage.raw((CharSequence)"OID", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitACI(ACIPropertyDefinition d, Void p) {
            return LocalizableMessage.raw((CharSequence)"ACI", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitBoolean(BooleanPropertyDefinition d, Void p) {
            if (this.isDetailed) {
                return LocalizableMessage.raw((CharSequence)"false | true", (Object[])new Object[0]);
            }
            return LocalizableMessage.raw((CharSequence)"BOOLEAN", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitClass(ClassPropertyDefinition d, Void p) {
            if (this.isDetailed && !d.getInstanceOfInterface().isEmpty()) {
                return LocalizableMessage.raw((CharSequence)("CLASS <= " + d.getInstanceOfInterface().get(0)), (Object[])new Object[0]);
            }
            return LocalizableMessage.raw((CharSequence)"CLASS", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitDN(DNPropertyDefinition d, Void p) {
            if (this.isDetailed && d.getBaseDN() != null) {
                return LocalizableMessage.raw((CharSequence)("DN <= " + d.getBaseDN()), (Object[])new Object[0]);
            }
            return LocalizableMessage.raw((CharSequence)"DN", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitDuration(DurationPropertyDefinition d, Void p) {
            LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
            DurationUnit unit = d.getBaseUnit();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                builder.append((CharSequence)DurationUnit.toString(d.getLowerLimit()));
                builder.append((CharSequence)" <= ");
            }
            builder.append((CharSequence)"DURATION (");
            builder.append((CharSequence)unit.getShortName());
            builder.append((CharSequence)")");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append((CharSequence)" <= ");
                    builder.append((CharSequence)DurationUnit.toString(d.getUpperLimit()));
                }
                if (d.isAllowUnlimited()) {
                    builder.append((CharSequence)" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public <E extends Enum<E>> LocalizableMessage visitEnum(EnumPropertyDefinition<E> d, Void p) {
            if (!this.isDetailed) {
                String name = d.getName();
                int i = name.lastIndexOf(45);
                if (i == -1 || i == name.length() - 1) {
                    return LocalizableMessage.raw((CharSequence)name.toUpperCase(), (Object[])new Object[0]);
                }
                return LocalizableMessage.raw((CharSequence)name.substring(i + 1).toUpperCase(), (Object[])new Object[0]);
            }
            TreeSet<String> values = new TreeSet<String>();
            for (Object value : EnumSet.allOf(d.getEnumClass())) {
                values.add(value.toString().trim().toLowerCase());
            }
            return LocalizableMessage.raw((CharSequence)Utils.joinAsString((String)" | ", values), (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitInteger(IntegerPropertyDefinition d, Void p) {
            LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
            if (this.isDetailed) {
                builder.append((CharSequence)String.valueOf(d.getLowerLimit()));
                builder.append((CharSequence)" <= ");
            }
            builder.append((CharSequence)"INTEGER");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append((CharSequence)" <= ");
                    builder.append((CharSequence)String.valueOf(d.getUpperLimit()));
                } else if (d.isAllowUnlimited()) {
                    builder.append((CharSequence)" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public LocalizableMessage visitIPAddress(IPAddressPropertyDefinition d, Void p) {
            return LocalizableMessage.raw((CharSequence)"HOST_NAME", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitIPAddressMask(IPAddressMaskPropertyDefinition d, Void p) {
            return LocalizableMessage.raw((CharSequence)"IP_ADDRESS_MASK", (Object[])new Object[0]);
        }

        @Override
        public LocalizableMessage visitSize(SizePropertyDefinition d, Void p) {
            LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                SizeUnit unit = SizeUnit.getBestFitUnitExact(d.getLowerLimit());
                builder.append((CharSequence)this.numberFormat.format(unit.fromBytes(d.getLowerLimit())));
                builder.append(' ');
                builder.append((CharSequence)unit.getShortName());
                builder.append((CharSequence)" <= ");
            }
            builder.append((CharSequence)"SIZE");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    long upperLimit = d.getUpperLimit();
                    SizeUnit unit = SizeUnit.getBestFitUnitExact(upperLimit);
                    if (unit == SizeUnit.BYTES && upperLimit < Long.MAX_VALUE) {
                        unit = SizeUnit.getBestFitUnitExact(upperLimit + 1L);
                        if (unit != SizeUnit.BYTES) {
                            ++upperLimit;
                            builder.append((CharSequence)" < ");
                        } else {
                            builder.append((CharSequence)" <= ");
                        }
                    } else {
                        builder.append((CharSequence)" <= ");
                    }
                    builder.append((CharSequence)this.numberFormat.format(unit.fromBytes(upperLimit)));
                    builder.append(' ');
                    builder.append((CharSequence)unit.getShortName());
                }
                if (d.isAllowUnlimited()) {
                    builder.append((CharSequence)" | unlimited");
                }
            }
            return builder.toMessage();
        }

        @Override
        public LocalizableMessage visitString(StringPropertyDefinition d, Void p) {
            if (d.getPattern() != null) {
                if (this.isDetailed) {
                    LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
                    builder.append((CharSequence)d.getPatternUsage());
                    builder.append((CharSequence)" - ");
                    builder.append(d.getPatternSynopsis());
                    return builder.toMessage();
                }
                return LocalizableMessage.raw((CharSequence)d.getPatternUsage(), (Object[])new Object[0]);
            }
            return LocalizableMessage.raw((CharSequence)"STRING", (Object[])new Object[0]);
        }

        @Override
        public <T> LocalizableMessage visitUnknown(PropertyDefinition<T> d, Void p) {
            return LocalizableMessage.raw((CharSequence)"?", (Object[])new Object[0]);
        }
    }
}

