/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.util.Reject;

public final class DNPropertyDefinition
extends PropertyDefinition<DN> {
    private final DN baseDN;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private DNPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<DN> defaultBehavior, DN baseDN) {
        super(d, DN.class, propertyName, options, adminAction, defaultBehavior);
        this.baseDN = baseDN;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    @Override
    public void validateValue(DN value) {
        Reject.ifNull((Object)value);
        if (this.baseDN != null) {
            DN parent = value.parent();
            if (parent == null) {
                parent = DN.rootDN();
            }
            if (!parent.equals((Object)this.baseDN)) {
                throw PropertyException.illegalPropertyValueException(this, value);
            }
        }
    }

    @Override
    public DN decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            DN dn = DN.valueOf((String)value);
            this.validateValue(dn);
            return dn;
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitDN(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, DN value, P p) {
        return v.visitDN(this, value, p);
    }

    @Override
    public int compare(DN o1, DN o2) {
        return o1.compareTo(o2);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<DN, DNPropertyDefinition> {
        private DN baseDN;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public void setBaseDN(String baseDN) {
            this.setBaseDN(baseDN != null ? DN.valueOf((String)baseDN) : null);
        }

        public void setBaseDN(DN baseDN) {
            this.baseDN = baseDN;
        }

        @Override
        protected DNPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<DN> defaultBehavior) {
            return new DNPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.baseDN);
        }
    }
}

