/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.ReleaseableIndexReader;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.ReaderUtil;

public class RefCountingIndexReader
extends FilterIndexReader
implements ReleaseableIndexReader {
    private int refCount = 1;

    public RefCountingIndexReader(IndexReader in) {
        super(in);
    }

    final synchronized void acquire() {
        ++this.refCount;
    }

    public synchronized int getRefCountJr() {
        return this.refCount;
    }

    @Override
    public final synchronized void release() throws IOException {
        if (--this.refCount == 0) {
            this.close();
        }
    }

    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return ReaderUtil.getMergedFieldInfos((IndexReader)this.in);
    }

    protected void doClose() throws IOException {
        Util.closeOrRelease(this.in);
    }
}

