/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.csrf.impl;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.ui.csrf.CSRFToken;
import net.shibboleth.idp.ui.csrf.CSRFTokenManager;
import net.shibboleth.idp.ui.csrf.InvalidCSRFTokenException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

public class CSRFTokenFlowExecutionListener
extends AbstractInitializableComponent
implements FlowExecutionListener {
    @Nonnull
    public static final String CSRF_TOKEN_VIEWSCOPE_NAME = "csrfToken";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CSRFTokenFlowExecutionListener.class);
    @NonnullAfterInit
    private BiPredicate<RequestContext, Event> eventRequiresCSRFTokenValidationPredicate;
    @NonnullAfterInit
    private Predicate<RequestContext> viewRequiresCSRFTokenPredicate;
    @Nonnull
    private boolean enabled = false;
    @NonnullAfterInit
    private CSRFTokenManager csrfTokenManager;

    public void setEnabled(@Nonnull boolean enable) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.enabled = enable;
    }

    public void setViewRequiresCSRFTokenPredicate(@Nonnull Predicate<RequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.viewRequiresCSRFTokenPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Does view require CSRF token predicate can not be null");
    }

    public void setEventRequiresCSRFTokenValidationPredicate(@Nonnull BiPredicate<RequestContext, Event> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.eventRequiresCSRFTokenValidationPredicate = (BiPredicate)Constraint.isNotNull(condition, (String)"Validate CSRF token condition cannot be null");
    }

    public void setCsrfTokenManager(@Nonnull CSRFTokenManager tokenManager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.csrfTokenManager = (CSRFTokenManager)Constraint.isNotNull((Object)tokenManager, (String)"CSRF Token manager can not be null");
    }

    public void viewRendering(@Nonnull RequestContext context, @Nonnull View view, @Nonnull StateDefinition viewState) {
        if (this.enabled && viewState.isViewState() && this.viewRequiresCSRFTokenPredicate.test(context)) {
            context.getViewScope().put(CSRF_TOKEN_VIEWSCOPE_NAME, (Object)this.csrfTokenManager.generateCSRFToken());
        }
    }

    public void eventSignaled(@Nonnull RequestContext context, @Nonnull Event event) {
        if (this.enabled && context.inViewState() && this.eventRequiresCSRFTokenValidationPredicate.test(context, event)) {
            String stateId = context.getCurrentState().getId();
            this.log.trace("Event '{}' signaled from view '{}' requires a CSRF token", (Object)event.getId(), (Object)stateId);
            Object storedCsrfTokenObject = context.getViewScope().get(CSRF_TOKEN_VIEWSCOPE_NAME);
            if (storedCsrfTokenObject == null || !(storedCsrfTokenObject instanceof CSRFToken)) {
                this.log.warn("CSRF token is required but was not found in the view-scope; for view-state '{}' and event '{}'.", (Object)stateId, (Object)event.getId());
                throw new InvalidCSRFTokenException(context.getActiveFlow().getId(), stateId, "Invalid CSRF token");
            }
            CSRFToken storedCsrfToken = (CSRFToken)storedCsrfTokenObject;
            String csrfTokenFromRequest = context.getExternalContext().getRequestParameterMap().get(storedCsrfToken.getParameterName());
            if (csrfTokenFromRequest == null || !(csrfTokenFromRequest instanceof String)) {
                this.log.warn("CSRF token is required but was not found in the request; for view-state '{}' and event '{}'.", (Object)stateId, (Object)event.getId());
                throw new InvalidCSRFTokenException(context.getActiveFlow().getId(), stateId, "Invalid CSRF token");
            }
            this.log.trace("Stored (viewScoped) CSRF Token '{}', CSRF Token in HTTP request '{}'", (Object)storedCsrfToken.getToken(), (Object)csrfTokenFromRequest);
            if (!this.csrfTokenManager.isValidCSRFToken(storedCsrfToken, csrfTokenFromRequest)) {
                this.log.warn("CSRF token in the request did not match that stored in the view-scope; for view-state '{}' and event '{}'.", (Object)stateId, (Object)event.getId());
                throw new InvalidCSRFTokenException(context.getActiveFlow().getId(), stateId, "Invalid CSRF token");
            }
        }
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.csrfTokenManager == null) {
            throw new ComponentInitializationException("CSRF token manager can not be null");
        }
        if (this.viewRequiresCSRFTokenPredicate == null) {
            throw new ComponentInitializationException("View requires CSRF token predicate can not be null");
        }
        if (this.eventRequiresCSRFTokenValidationPredicate == null) {
            throw new ComponentInitializationException("Event requires CSRF token validation predicate can not be null");
        }
    }
}

