/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMessageReceivedEndpointContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"%{idp.authn.saml.externalAuthnPath:/Authn/SAML2}"})
public class SAMLAuthnController
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLAuthnController.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileRequestContext> profileRequestContextLookupStrategy = new ChildContextLookup(ProfileRequestContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, SAMLAuthnContext> samlContextLookupStrategy = new ChildContextLookup(SAMLAuthnContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setSAMLAuthnContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLAuthnContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.samlContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLAuthnContext lookup strategy cannot be null");
    }

    @GetMapping(value={"/{binding}/SSO/start"})
    @Nullable
    public void startSAML(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @PathVariable @Nonnull @NotEmpty String binding) throws ExternalAuthenticationException, IOException {
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        SAMLAuthnContext samlContext = this.samlContextLookupStrategy.apply(prc);
        if (samlContext == null) {
            this.log.error("SAMLAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        if (nestedPRC.getOutboundMessageContext() == null || !(nestedPRC.getOutboundMessageContext().getMessage() instanceof AuthnRequest)) {
            this.log.error("Outbound AuthnContext message not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidMessage");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        SAMLBindingSupport.setRelayState((MessageContext)nestedPRC.getOutboundMessageContext(), (String)key);
        StringBuffer url = httpRequest.getRequestURL();
        ((AuthnRequest)nestedPRC.getOutboundMessageContext().getMessage()).setAssertionConsumerServiceURL(url.substring(0, url.lastIndexOf("/start")));
        try {
            if (samlContext.getOutboundMessageHandler() != null) {
                samlContext.getOutboundMessageHandler().invoke(nestedPRC.getOutboundMessageContext());
            }
            samlContext.getEncodeMessageAction().execute(nestedPRC);
            EventContext eventCtx = (EventContext)prc.getSubcontext(EventContext.class);
            if (eventCtx != null && eventCtx.getEvent() != null && !"proceed".equals(eventCtx.getEvent())) {
                this.log.error("Message encoding action signaled non-proceed event {}", eventCtx.getEvent());
                httpRequest.setAttribute("authnError", (Object)eventCtx.getEvent().toString());
                ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                return;
            }
        }
        catch (MessageHandlerException e) {
            this.log.error("Caught message handling exception", (Throwable)e);
            httpRequest.setAttribute("authnError", (Object)"MessageProcessingError");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{binding}/SSO"})
    @Nullable
    public void finishSAML(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @PathVariable @Nonnull @NotEmpty String binding) throws ExternalAuthenticationException, IOException {
        String key = httpRequest.getParameter("RelayState");
        if (key == null) {
            throw new ExternalAuthenticationException("No RelayState parameter, unable to resume flow execution");
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        SAMLAuthnContext samlContext = this.samlContextLookupStrategy.apply(prc);
        if (samlContext == null) {
            this.log.error("SAMLAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        try {
            MessageDecoder decoder = samlContext.getMessageDecoderFactory().apply(binding);
            if (decoder == null) {
                throw new MessageDecodingException("Unable to obtain MessageDecoder for binding key: " + binding);
            }
            try {
                decoder.initialize();
                decoder.decode();
                MessageContext messageContext = decoder.getMessageContext();
                messageContext.addSubcontext((BaseContext)new SAMLMessageReceivedEndpointContext(httpRequest));
                nestedPRC.setInboundMessageContext(messageContext);
            }
            finally {
                decoder.destroy();
            }
        }
        catch (ComponentInitializationException | MessageDecodingException e) {
            this.log.error("Unable to decode SAML response", e);
            httpRequest.setAttribute("authnError", (Object)"UnableToDecode");
        }
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }
}

