/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFrameworkHandler
extends AbstractMessageHandler {
    public static final String DEFAULT_VERSION = "2.0";
    private Logger log = LoggerFactory.getLogger(ProcessFrameworkHandler.class);
    private String expectedVersion = "2.0";

    @Nullable
    public String getExpectedVersion() {
        return this.expectedVersion;
    }

    public void setExpectedVersion(@Nullable String version) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.expectedVersion = StringSupport.trimOrNull((String)version);
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        Framework header = this.getFramework(messageContext);
        String headerVersion = header != null ? StringSupport.trimOrNull((String)header.getVersion()) : null;
        this.log.debug("Checking inbound message Liberty ID-WSF Framework version value: {}", (Object)headerVersion);
        if (!Objects.equals(this.getExpectedVersion(), headerVersion)) {
            this.log.warn("Inbound Liberty ID-WSF Framework version '{}' did not match the expected value '{}'", (Object)headerVersion, (Object)this.getExpectedVersion());
            SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (QName)new QName("urn:liberty:sb", Konstantz.Status.FRAMEWORK_VERSION_MISMATCH.getCode()), (String)("Framework version not supported: " + headerVersion), null, null, null);
            throw new MessageHandlerException("Inbound Liberty ID-WSF Framework version did not match the expected value");
        }
        this.log.debug("Inbound Liberty ID-WSF Framework version matched expected value");
        SOAPMessagingSupport.registerUnderstoodHeader((MessageContext)messageContext, (XMLObject)header);
    }

    protected Framework getFramework(@Nonnull MessageContext messageContext) {
        List frameworks = SOAPMessagingSupport.getInboundHeaderBlock((MessageContext)messageContext, (QName)Framework.DEFAULT_ELEMENT_NAME);
        if (frameworks != null && !frameworks.isEmpty()) {
            return (Framework)frameworks.get(0);
        }
        return null;
    }
}

