/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByQueriedAttributeDesignators
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributeDesignators.class);
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private Function<ProfileRequestContext, Request> requestLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private AttributeQuery query;
    @Nullable
    private AttributeContext attributeContext;

    public FilterByQueriedAttributeDesignators() {
        this.requestLookupStrategy = new MessageLookup(Request.class).compose((Function)new InboundMessageContextLookup());
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, Request> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Request request = this.requestLookupStrategy.apply(profileRequestContext);
        if (request != null) {
            this.query = request.getAttributeQuery();
        }
        if (this.query == null || this.query.getAttributeDesignators().isEmpty()) {
            this.log.debug("No AttributeDesignators found, nothing to do ");
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HashSet<String> decodedAttributeIds = new HashSet<String>();
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transcoder service unavailable");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
                return;
            }
            for (AttributeDesignator designator : this.query.getAttributeDesignators()) {
                try {
                    this.decodeAttributeDesignator((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, decodedAttributeIds);
                }
                catch (AttributeDecodingException e) {
                    this.log.warn("{} Error decoding AttributeDesignators", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
        finally {
            if (component != null) {
                component.unpinComponent();
            }
        }
        ArrayList<IdPAttribute> keepers = new ArrayList<IdPAttribute>(this.query.getAttributeDesignators().size());
        this.log.debug("Query content mapped to attribute IDs: {}", decodedAttributeIds);
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            if (decodedAttributeIds.contains(attribute.getId())) {
                this.log.debug("Retaining attribute '{}' requested by query", (Object)attribute.getId());
                keepers.add(attribute);
                continue;
            }
            this.log.debug("Removing attribute '{}' not requested by query", (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes(keepers);
    }

    private void decodeAttributeDesignator(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeDesignator input, @Nonnull @NonnullElements @Live Collection<String> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            throw new AttributeDecodingException("No transcoding rule for AttributeDesignator '" + input.getAttributeName() + "'");
        }
        for (TranscodingRule rules : transcodingRules) {
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.add(decodedAttribute.getId());
        }
    }
}

