/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ThreadSafeAfterInit
public class SpringAwareMessageDecoderFactory
extends AbstractInitializableComponent
implements Function<String, MessageDecoder>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringAwareMessageDecoderFactory.class);
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private Map<String, String> beanMappings = Collections.emptyMap();

    public void setBeanMappings(@Nonnull Map<String, String> mappings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(mappings, (String)"Mappings cannot be null");
        this.beanMappings = new HashMap<String, String>(mappings.size());
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String key = StringSupport.trimOrNull((String)entry.getKey());
            String value = StringSupport.trimOrNull((String)entry.getValue());
            if (key == null || value == null) continue;
            this.beanMappings.put(key, value);
        }
    }

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    @Nullable
    public MessageDecoder apply(@Nullable String input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String beanID = this.beanMappings.get(StringSupport.trimOrNull((String)input));
        if (this.applicationContext == null) {
            this.log.warn("No Spring ApplicationContext set");
            return null;
        }
        if (beanID == null) {
            this.log.warn("No bean ID associated with input value {}", (Object)input);
            return null;
        }
        this.log.debug("Looking up message decoder with bean ID: {}", (Object)beanID);
        try {
            return (MessageDecoder)this.applicationContext.getBean(beanID, MessageDecoder.class);
        }
        catch (BeansException e) {
            this.log.warn("Error instantiating message decoder from bean ID {}", (Object)beanID, (Object)e);
            return null;
        }
    }
}

