/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.profile.impl.SAMLRelyingPartyIdLookupStrategy;
import net.shibboleth.idp.saml.profile.impl.SAMLVerificationLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeRelyingPartyContextFromSAMLPeer
extends AbstractMessageHandler {
    @Nonnull
    private static final Function<RelyingPartyContext, String> RPID_LOOKUP = new SAMLRelyingPartyIdLookupStrategy();
    @Nonnull
    private static final Function<RelyingPartyContext, Boolean> VERIFY_LOOKUP = new SAMLVerificationLookupStrategy();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRelyingPartyContextFromSAMLPeer.class);
    @Nonnull
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextCreationStrategy = new ChildContextLookup(RelyingPartyContext.class, true).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    @Nonnull
    private Function<MessageContext, SAMLPeerEntityContext> peerEntityContextLookupStrategy = new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    @Nullable
    private SAMLPeerEntityContext peerEntityCtx;

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setPeerEntityContextLookupStrategy(@Nonnull Function<MessageContext, SAMLPeerEntityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLPeerEntityContext lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.peerEntityCtx = this.peerEntityContextLookupStrategy.apply(messageContext);
        if (this.peerEntityCtx == null) {
            this.log.debug("{} Unable to locate SAMLPeerEntityContext", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Unable to locate SAMLPeerEntityContext");
        }
        return super.doPreInvoke(messageContext);
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        RelyingPartyContext rpContext = this.relyingPartyContextCreationStrategy.apply(messageContext);
        if (rpContext == null) {
            this.log.debug("{} Unable to locate or create RelyingPartyContext", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Unable to locate or create RelyingPartyContext");
        }
        this.log.debug("{} Attaching RelyingPartyContext based on SAML peer {}", (Object)this.getLogPrefix(), (Object)this.peerEntityCtx.getEntityId());
        rpContext.setRelyingPartyIdContextTree((BaseContext)this.peerEntityCtx);
        rpContext.setRelyingPartyIdLookupStrategy(RPID_LOOKUP);
        rpContext.setVerificationLookupStrategy(VERIFY_LOOKUP);
    }
}

