/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectQuery;

public class SPNameQualifierAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public SPNameQualifierAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject msg = this.messageLookupStrategy.apply(input);
        if (msg != null) {
            if (msg instanceof ArtifactResponse) {
                msg = ((ArtifactResponse)msg).getMessage();
            }
            if (msg instanceof Response) {
                for (Assertion assertion : ((Response)msg).getAssertions()) {
                    String qualifier = this.apply(assertion);
                    if (qualifier == null) continue;
                    return qualifier;
                }
            } else if (msg instanceof LogoutRequest) {
                if (((LogoutRequest)msg).getNameID() != null) {
                    return ((LogoutRequest)msg).getNameID().getSPNameQualifier();
                }
            } else if (msg instanceof AuthnRequest) {
                if (((AuthnRequest)msg).getSubject() != null && ((AuthnRequest)msg).getSubject().getNameID() != null) {
                    return ((AuthnRequest)msg).getSubject().getNameID().getSPNameQualifier();
                }
            } else if (msg instanceof SubjectQuery) {
                if (((SubjectQuery)msg).getSubject() != null && ((SubjectQuery)msg).getSubject().getNameID() != null) {
                    return ((SubjectQuery)msg).getSubject().getNameID().getSPNameQualifier();
                }
            } else if (msg instanceof Assertion) {
                return this.apply((Assertion)msg);
            }
        }
        return null;
    }

    @Override
    @Nullable
    private String apply(@Nonnull Assertion assertion) {
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            return assertion.getSubject().getNameID().getSPNameQualifier();
        }
        return null;
    }
}

