/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.DataSealerArguments;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.security.DataSealer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSealerCLI
extends AbstractIdPHomeAwareCommandLine<DataSealerArguments> {
    @Nullable
    private Logger log;

    @Nonnull
    protected Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DataSealerCLI.class);
        }
        return this.log;
    }

    @Nonnull
    protected Class<DataSealerArguments> getArgumentClass() {
        return DataSealerArguments.class;
    }

    @Nonnull
    @NotEmpty
    protected String getVersion() {
        return Version.getVersion();
    }

    @Override
    protected int doRun(@Nonnull DataSealerArguments args) {
        int ret = super.doRun(args);
        if (ret != 0) {
            return ret;
        }
        try {
            DataSealer sealer = args.getDataSealerName() != null ? (DataSealer)this.getApplicationContext().getBean(args.getDataSealerName(), DataSealer.class) : (DataSealer)this.getApplicationContext().getBean(DataSealer.class);
            switch (args.getOperation()) {
                case WRAP: {
                    System.out.println(sealer.wrap((String)args.getOtherArgs().get(2)));
                    break;
                }
                case UNWRAP: {
                    System.out.println(sealer.unwrap((String)args.getOtherArgs().get(2)));
                    break;
                }
                default: {
                    this.getLogger().error("Invalid operation");
                    return 2;
                }
            }
        }
        catch (Exception e) {
            if (args.isVerboseOutput()) {
                this.getLogger().error("Unable to access DataSealer from Spring context", (Throwable)e);
            } else {
                this.getLogger().error("Unable to access DataSealer from Spring context", (Object)e.getMessage());
            }
            return -1;
        }
        return 0;
    }

    public static void main(@Nonnull String[] args) {
        System.exit(new DataSealerCLI().run(args));
    }
}

