/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSealerArguments
extends AbstractIdPHomeAwareCommandLineArguments {
    @Parameter(names={"--dataSealer"})
    @Nullable
    private String dataSealerName;
    @Nullable
    private Logger log;
    @Nullable
    private OperationType operation;

    public Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DataSealerArguments.class);
        }
        return this.log;
    }

    @Nullable
    public String getDataSealerName() {
        return this.dataSealerName;
    }

    @Nullable
    public OperationType getOperation() {
        return this.operation;
    }

    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.getOtherArgs().size() < 3) {
            throw new IllegalArgumentException("Missing one or more required arguments");
        }
        if ("enc".equals(this.getOtherArgs().get(1))) {
            this.operation = OperationType.WRAP;
        } else if ("dec".equals(this.getOtherArgs().get(1))) {
            this.operation = OperationType.UNWRAP;
        } else {
            throw new IllegalArgumentException("Invalid operation requested, must be one of enc|dec");
        }
    }

    @Override
    public void printHelp(PrintStream out) {
        out.println("DataSealerCLI");
        out.println("Provides a command line interface for DataSealer wrap/unwrap operations.");
        out.println();
        out.println("   DataSealerCLI [options] springConfiguration enc|dec string");
        out.println();
        out.println("      springConfiguration      name of Spring configuration resource to use");
        out.println("      enc|dec                  encrypt or decrypt operation");
        out.println("      string                   value to encrypt or decrypt");
        super.printHelp(out);
        out.println();
        out.println(String.format("  --%-20s %s", "dataSealer", "Specifies a non-default DataSealer bean to use."));
        out.println();
    }

    public static enum OperationType {
        WRAP,
        UNWRAP;

    }
}

