/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.cli.AbstractCommandLineArguments;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractIdPHomeAwareCommandLineArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"--home"})
    @Nullable
    private String idpHome;
    @Parameter(names={"-hc", "--http-client"})
    @Nullable
    @NotEmpty
    private String httpClientName;
    @Parameter(names={"-hs", "--http-security"})
    @Nullable
    @NotEmpty
    private String httpClientSecurityParametersName;

    @Nullable
    public String getIdPHome() {
        return this.idpHome;
    }

    @Nullable
    @NotEmpty
    public String getHttpClientName() {
        return this.httpClientName;
    }

    public void setHttpClientName(@Nullable @NotEmpty String name) {
        this.httpClientName = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    @NotEmpty
    public String getHttpClientSecurityParameterstName() {
        return this.httpClientSecurityParametersName;
    }

    public void printHelp(PrintStream out) {
        super.printHelp(out);
        out.println(String.format("  --%-20s %s", "home", "Sets idp.home if not installed to default location."));
        out.println(String.format("  %-22s %s", "-hc, --http-client", "Use the named bean for HTTP operations"));
        out.println(String.format("  %-22s %s", "-hs, --http-security", "Use the named bean for HTTP security"));
        out.println();
    }
}

