/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;

public class ReloadableServiceGaugeSet<T>
extends AbstractInitializableComponent
implements MetricSet,
MetricFilter {
    @Nonnull
    @NotEmpty
    protected static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp";
    @Nonnull
    @NonnullElements
    private final Map<String, Metric> gauges;
    @NonnullAfterInit
    private ReloadableService<T> service;
    @Nonnull
    @NotEmpty
    private final String logPrefix;

    public ReloadableServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        this.logPrefix = Constraint.isNotEmpty((String)metricName, (String)"Metric name cannot be null or empty");
        this.gauges = new HashMap<String, Metric>();
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{metricName, "reload", "success"}), (Metric)new Gauge<Instant>(){

            public Instant getValue() {
                return ReloadableServiceGaugeSet.this.service.getLastSuccessfulReloadInstant();
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{metricName, "reload", "attempt"}), (Metric)new Gauge<Instant>(){

            public Instant getValue() {
                return ReloadableServiceGaugeSet.this.service.getLastReloadAttemptInstant();
            }
        });
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{metricName, "reload", "error"}), (Metric)new Gauge<String>(){

            public String getValue() {
                return ReloadableServiceGaugeSet.this.service.getReloadFailureCause() != null ? ReloadableServiceGaugeSet.this.service.getReloadFailureCause().getMessage() : null;
            }
        });
    }

    @NonnullAfterInit
    public ReloadableService<T> getService() {
        return this.service;
    }

    public void setService(@Nonnull ReloadableService<T> svc) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.service = (ReloadableService)Constraint.isNotNull(svc, (String)"ReloadableService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.service == null) {
            throw new ComponentInitializationException("Injected ReloadableService cannot be null");
        }
        super.doInitialize();
    }

    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.gauges);
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Metric> getMetricMap() {
        return this.gauges;
    }

    @Nonnull
    @NotEmpty
    protected final String getLogPrefix() {
        return this.logPrefix;
    }
}

