/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.JCommander;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cli.CommandLineArguments;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

public final class CLI {
    @Nonnull
    @NotEmpty
    public static final String ARGS_PROPERTY = "net.shibboleth.idp.cli.arguments";

    private CLI() {
    }

    public static void main(@Nonnull String[] args) throws ReflectiveOperationException, SecurityException, IllegalArgumentException {
        String argType = System.getProperty(ARGS_PROPERTY);
        if (argType == null) {
            CLI.errorAndExit("net.shibboleth.idp.cli.arguments system property not set");
        }
        CommandLineArguments argObject = null;
        try {
            Constructor<?> construct = Class.forName(argType).getConstructor(new Class[0]);
            Object obj = construct.newInstance(new Object[0]);
            if (!(obj instanceof CommandLineArguments)) {
                CLI.errorAndExit("Argument class was not of the correct type");
            }
            argObject = (CommandLineArguments)obj;
            JCommander jc = new JCommander((Object)argObject);
            jc.parse(args);
            if (argObject.isUsage()) {
                jc.usage();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            CLI.errorAndExit("Argument class " + argType + " not found ");
        }
        catch (IllegalAccessException | InstantiationException e) {
            CLI.errorAndExit(e.getMessage());
        }
        try {
            argObject.validate();
        }
        catch (IllegalArgumentException e) {
            CLI.errorAndExit(e.getMessage());
        }
        CLI.doRequest(argObject);
    }

    private static void doRequest(@Nonnull CommandLineArguments args) {
        URL url = null;
        try {
            url = args.buildURL();
            try (InputStream stream = url.openStream();
                 InputStreamReader reader = new InputStreamReader(stream);
                 BufferedReader in = new BufferedReader(reader);){
                String line;
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }
        catch (MalformedURLException e) {
            CLI.errorAndExit(e.getMessage());
        }
        catch (IOException e) {
            CLI.errorAndExit((String)(url != null ? "(" + url.toString() + ") " : "") + e.getMessage());
        }
    }

    private static void errorAndExit(@Nonnull String errorMessage) {
        System.err.println(errorMessage);
        System.exit(1);
    }
}

