/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.shibboleth.idp.cli.CommandLineArguments;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

@Parameters(separators=" =")
public abstract class AbstractCommandLineArguments
implements CommandLineArguments {
    @Nonnull
    @NotEmpty
    public static final String BASEURL_PROPERTY = "net.shibboleth.idp.cli.baseURL";
    @Parameter(names={"-h", "--help"}, description="Display program usage", help=true)
    private boolean help;
    @Parameter(names={"-u", "--url"}, description="Base URL to invoke (path and query string will be appended)")
    @Nonnull
    private String url = System.getProperty("net.shibboleth.idp.cli.baseURL");
    @Parameter(names={"-p", "--path"}, description="Path to append to base URL to invoke")
    @Nullable
    private String path;
    @Parameter(names={"-k", "--disableNameChecking"}, description="Disable TLS certificate name checking")
    private boolean disableNameChecking;
    @Parameter(names={"-ts", "--trustStore"}, description="Path to a trust store for SSL connections")
    @Nullable
    private String trustStore;
    @Parameter(names={"-tt", "--trustStoreType"}, description="Type of trust store for SSL connections")
    @Nullable
    private String trustStoreType;
    @Parameter(names={"-tp", "--trustStorePassword"}, description="Password to a trust store for SSL connections")
    @Nullable
    private String trustStorePassword;

    public AbstractCommandLineArguments() {
        if (this.url == null) {
            this.url = "http://localhost/idp";
        }
    }

    public boolean getHelp() {
        return this.help;
    }

    @Nonnull
    public String getURL() {
        return this.url;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getTrustStore() {
        return this.trustStore;
    }

    @Nullable
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean isDisableNameChecking() {
        return this.disableNameChecking;
    }

    @Override
    public boolean isUsage() {
        return this.help;
    }

    @Override
    public void validate() {
    }

    @Override
    @Nonnull
    public URL buildURL() throws MalformedURLException {
        this.installTrustStore();
        if (this.disableNameChecking) {
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        StringBuilder builder = new StringBuilder(this.getURL());
        if (this.getPath() != null) {
            builder.append(this.getPath());
        }
        return new URL(this.doBuildURL(builder).toString());
    }

    @Nonnull
    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        return builder;
    }

    private void installTrustStore() {
        if (this.trustStoreType != null) {
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            if (this.trustStoreType != null) {
                System.setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
            }
            if (this.trustStorePassword != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            }
        }
    }
}

