/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.spring;

import com.codahale.metrics.MetricRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSAMLConfigBean
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OpenSAMLConfigBean.class);
    @Nullable
    private ParserPool parserPool;
    @Nullable
    private MetricRegistry metricRegistry;

    @Nullable
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nullable ParserPool newParserPool) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parserPool = newParserPool;
    }

    @Nullable
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(@Nullable MetricRegistry registry) {
        this.metricRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new ComponentInitializationException("Exception initializing OpenSAML", (Exception)((Object)e));
        }
        XMLObjectProviderRegistry registry = null;
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            if (this.metricRegistry != null) {
                ConfigurationService.register(MetricRegistry.class, (Object)this.metricRegistry);
            }
            if ((registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class)) == null) {
                this.log.debug("XMLObjectProviderRegistry did not exist in ConfigurationService, will be created");
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            if (this.parserPool != null) {
                registry.setParserPool(this.parserPool);
            }
            return;
        }
    }
}

