/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateCredentials
extends AbstractValidationAction
implements CredentialValidator.WarningHandler,
CredentialValidator.ErrorHandler {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateCredentials.class);
    @Nonnull
    @NonnullElements
    private List<CredentialValidator> credentialValidators;
    private boolean requireAll;
    @Nullable
    private AccountLockoutManager lockoutManager;
    @Nonnull
    @NonnullElements
    private Collection<Subject> results;
    @Nullable
    private CredentialValidator currentValidator;
    private boolean warningSignaled;
    private boolean errorSignaled;

    public ValidateCredentials() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.credentialValidators = Collections.emptyList();
        this.results = new ArrayList<Subject>(1);
    }

    public void setLockoutManager(@Nullable AccountLockoutManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lockoutManager = manager;
    }

    public void setValidators(@Nonnull @NonnullElements List<CredentialValidator> validators) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.credentialValidators = List.copyOf((Collection)Constraint.isNotNull(validators, (String)"Validators list cannot be null"));
    }

    public void setRequireAll(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireAll = flag;
    }

    @Nonnull
    @NotEmpty
    public String getMetricName() {
        return super.getMetricName() + "." + this.currentValidator.getId();
    }

    public void handleWarning(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        this.warningSignaled = true;
        super.handleWarning(profileRequestContext, authenticationContext, message, eventId);
    }

    public void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        this.errorSignaled = true;
        super.handleError(profileRequestContext, authenticationContext, message, eventId);
    }

    public void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Exception e, @Nonnull @NotEmpty String eventId) {
        this.errorSignaled = true;
        super.handleError(profileRequestContext, authenticationContext, e, eventId);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.lockoutManager != null && this.lockoutManager.check(profileRequestContext)) {
            this.log.info("{} Account locked out, aborting authentication", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "AccountLocked", "AccountLocked");
            return;
        }
        for (CredentialValidator validator : this.credentialValidators) {
            this.log.trace("{} Attempting credential validation via {}", (Object)this.getLogPrefix(), (Object)validator.getId());
            this.currentValidator = validator;
            try {
                Subject subject = this.currentValidator.validate(profileRequestContext, authenticationContext, (CredentialValidator.WarningHandler)this, (CredentialValidator.ErrorHandler)this);
                if (subject == null) continue;
                this.results.add(subject);
                if (this.requireAll) continue;
                this.recordSuccess(profileRequestContext);
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                if (!this.warningSignaled) {
                    ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                }
                return;
            }
            catch (Exception e) {
                this.recordFailure();
                if (this.requireAll) {
                    super.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
                    this.errorSignaled = true;
                    break;
                }
                if (this.errorSignaled) continue;
                super.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
                this.errorSignaled = true;
            }
        }
        if (this.requireAll && !this.errorSignaled && !this.results.isEmpty()) {
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            if (!this.warningSignaled) {
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
            }
            return;
        }
        if (this.errorSignaled) {
            if (this.lockoutManager != null) {
                this.lockoutManager.increment(profileRequestContext);
            }
        } else {
            this.log.warn("{} No validators were available or usable", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "RequestUnsupported", "RequestUnsupported");
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        for (Subject s : this.results) {
            subject.getPrincipals().addAll(s.getPrincipals());
            subject.getPublicCredentials().addAll(s.getPublicCredentials());
            subject.getPrivateCredentials().addAll(s.getPrivateCredentials());
        }
        return subject;
    }

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        this.recordSuccess();
        if (this.lockoutManager != null) {
            this.lockoutManager.clear(profileRequestContext);
        }
    }
}

