/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JAASCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JAASCredentialValidator.class);
    @Nullable
    private String loginConfigType;
    @Nullable
    private Configuration.Parameters loginConfigParameters;
    @Nonnull
    private Collection<Pair<String, Subject>> loginConfigurations = Collections.singletonList(new Pair((Object)"ShibUserPassAuth", null));
    @Nullable
    private Function<ProfileRequestContext, Collection<Pair<String, Subject>>> loginConfigStrategy;

    @Nullable
    public String getLoginConfigType() {
        return this.loginConfigType;
    }

    public void setLoginConfigType(@Nullable String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigType = StringSupport.trimOrNull((String)type);
    }

    @Nullable
    public Configuration.Parameters getLoginConfigParameters() {
        return this.loginConfigParameters;
    }

    public void setLoginConfigParameters(@Nullable Configuration.Parameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigParameters = params;
    }

    public void setLoginConfigurations(@Nullable Collection<Pair<String, Collection<Principal>>> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (configs != null) {
            this.loginConfigurations = new ArrayList<Pair<String, Subject>>(configs.size());
            for (Pair<String, Collection<Principal>> config : configs) {
                String trimmed = StringSupport.trimOrNull((String)((String)config.getFirst()));
                if (trimmed == null) continue;
                if (config.getSecond() == null || ((Collection)config.getSecond()).isEmpty()) {
                    this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, null));
                    continue;
                }
                Subject subject = new Subject();
                subject.getPrincipals().addAll((Collection)config.getSecond());
                this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, (Object)subject));
            }
        }
    }

    public void setLoginConfigNames(@Nullable @NonnullElements Collection<String> names) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (names != null) {
            this.loginConfigurations = new ArrayList<Pair<String, Subject>>(names.size());
            for (String name : names) {
                String trimmed = StringSupport.trimOrNull((String)name);
                if (trimmed == null) continue;
                this.loginConfigurations.add((Pair<String, Subject>)new Pair((Object)trimmed, null));
            }
        }
    }

    public void setLoginConfigStrategy(@Nullable Function<ProfileRequestContext, Collection<Pair<String, Subject>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginConfigStrategy = strategy;
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        RequestedPrincipalContext requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class);
        Collection<Pair<String, Subject>> configs = this.loginConfigStrategy != null ? this.loginConfigStrategy.apply(profileRequestContext) : this.loginConfigurations;
        Exception caughtException = null;
        for (Pair<String, Subject> loginConfig : configs) {
            if (!this.isAcceptable(requestedPrincipalCtx, (Subject)loginConfig.getSecond(), (String)loginConfig.getFirst())) continue;
            String currentLoginConfigName = (String)loginConfig.getFirst();
            try {
                this.log.debug("{} Attempting to authenticate user '{}' via '{}'", new Object[]{this.getLogPrefix(), usernamePasswordContext.getTransformedUsername(), currentLoginConfigName});
                Subject subject = this.authenticate(currentLoginConfigName, usernamePasswordContext);
                this.log.info("{} Login by '{}' via '{}' succeeded", new Object[]{this.getLogPrefix(), usernamePasswordContext.getTransformedUsername(), currentLoginConfigName});
                return this.populateSubject(subject, (Subject)loginConfig.getSecond(), usernamePasswordContext);
            }
            catch (LoginException e) {
                this.log.info("{} Login by '{}' via '{}' failed", new Object[]{this.getLogPrefix(), usernamePasswordContext.getTransformedUsername(), currentLoginConfigName, e});
                if (errorHandler != null) {
                    errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
                }
                caughtException = e;
            }
            catch (Exception e) {
                this.log.warn("{} Login by '{}' via '{}' produced exception", new Object[]{this.getLogPrefix(), usernamePasswordContext.getTransformedUsername(), currentLoginConfigName, e});
                if (errorHandler != null) {
                    errorHandler.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
                }
                caughtException = e;
            }
        }
        if (caughtException == null) {
            this.log.info("{} No JAAS application configurations are available or acceptable for use", (Object)this.getLogPrefix());
            return null;
        }
        throw caughtException;
    }

    @Nonnull
    private Subject authenticate(@Nonnull @NotEmpty String loginConfigName, @Nonnull UsernamePasswordContext usernamePasswordContext) throws LoginException, NoSuchAlgorithmException {
        LoginContext jaasLoginCtx;
        if (this.getLoginConfigType() != null) {
            this.log.debug("{} Using custom JAAS configuration type {} with parameters of type {}", new Object[]{this.getLogPrefix(), this.getLoginConfigType(), this.getLoginConfigParameters().getClass().getName()});
            Configuration loginConfig = Configuration.getInstance(this.getLoginConfigType(), this.getLoginConfigParameters());
            jaasLoginCtx = new LoginContext(loginConfigName, null, new SimpleCallbackHandler(usernamePasswordContext), loginConfig);
        } else {
            this.log.debug("{} Using system JAAS configuration", (Object)this.getLogPrefix());
            jaasLoginCtx = new LoginContext(loginConfigName, null, new SimpleCallbackHandler(usernamePasswordContext));
        }
        jaasLoginCtx.login();
        return jaasLoginCtx.getSubject();
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject, @Nullable Subject derivedSubject, @Nonnull UsernamePasswordContext usernamePasswordContext) {
        if (derivedSubject != null) {
            subject.getPrincipals().addAll(derivedSubject.getPrincipals());
        }
        return super.populateSubject(subject, usernamePasswordContext);
    }

    protected class SimpleCallbackHandler
    implements CallbackHandler {
        @Nonnull
        private final UsernamePasswordContext context;

        public SimpleCallbackHandler(UsernamePasswordContext usernamePasswordContext) {
            this.context = usernamePasswordContext;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(this.context.getTransformedUsername());
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback pcb = (PasswordCallback)cb;
                pcb.setPassword(this.context.getPassword().toCharArray());
            }
        }
    }
}

