/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.session.context.SessionContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FinalizeAuthentication.class);
    @Nullable
    private String canonicalPrincipalName;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        AuthenticationResult latest;
        SessionContext sessionCtx;
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        SubjectCanonicalizationContext c14nCtx = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        if (c14nCtx != null) {
            this.canonicalPrincipalName = c14nCtx.getPrincipalName();
            profileRequestContext.removeSubcontext((BaseContext)c14nCtx);
            this.log.debug("{} Canonical principal name was established as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if (this.canonicalPrincipalName == null && (sessionCtx = (SessionContext)profileRequestContext.getSubcontext(SessionContext.class)) != null && sessionCtx.getIdPSession() != null) {
            this.canonicalPrincipalName = sessionCtx.getIdPSession().getPrincipalName();
            this.log.debug("{} Canonical principal name established from session as '{}'", (Object)this.getLogPrefix(), (Object)this.canonicalPrincipalName);
        }
        if ((latest = authenticationContext.getAuthenticationResult()) == null) {
            this.log.warn("{} Authentication result missing from context?", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        AuthenticationFlowDescriptor flowDescriptor = (AuthenticationFlowDescriptor)authenticationContext.getAvailableFlows().get(latest.getAuthenticationFlowId());
        if (flowDescriptor.isProxyRestrictionsEnforced() && !this.checkProxyRestrictions(profileRequestContext, latest.getSubject())) {
            return false;
        }
        RequestedPrincipalContext requestedPrincipalCtx = (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class);
        if (requestedPrincipalCtx != null) {
            Principal match = requestedPrincipalCtx.getMatchingPrincipal();
            if (match != null && !latest.getSupportedPrincipals(match.getClass()).contains(match)) {
                this.log.debug("{} Authentication result lacks originally projected matching principal '{}', reevaluating", (Object)this.getLogPrefix(), (Object)match.getName());
                requestedPrincipalCtx.setMatchingPrincipal(null);
            }
            requestedPrincipalCtx.setMatchingPrincipal(this.findMatchingPrincipal(authenticationContext, requestedPrincipalCtx));
            if (requestedPrincipalCtx.getMatchingPrincipal() == null) {
                this.log.warn("{} Authentication result for flow {} did not satisfy the request", (Object)this.getLogPrefix(), (Object)latest.getAuthenticationFlowId());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
                return false;
            }
        } else {
            this.log.debug("{} Request did not have explicit authentication requirements, result is accepted", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.canonicalPrincipalName != null) {
            SubjectContext sc = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, true);
            if (sc.getPrincipalName() != null && !this.canonicalPrincipalName.equals(sc.getPrincipalName())) {
                this.log.warn("{} Result of authentication ({}) does not match existing subject in context ({})", new Object[]{this.getLogPrefix(), this.canonicalPrincipalName, sc.getPrincipalName()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectContext");
                return;
            }
            sc.setPrincipalName(this.canonicalPrincipalName);
            Map scResults = sc.getAuthenticationResults();
            scResults.putAll(authenticationContext.getActiveResults());
            AuthenticationResult latest = authenticationContext.getAuthenticationResult();
            if (latest != null) {
                scResults.put(latest.getAuthenticationFlowId(), latest);
            }
        }
        authenticationContext.setCompletionInstant();
    }

    @Nullable
    protected Principal findMatchingPrincipal(@Nonnull AuthenticationContext authenticationContext, @Nonnull RequestedPrincipalContext requestedPrincipalCtx) {
        ArrayList<Principal> matches = new ArrayList<Principal>();
        for (Principal p : requestedPrincipalCtx.getRequestedPrincipals()) {
            this.log.debug("{} Checking result for compatibility with operator '{}' and principal '{}'", new Object[]{this.getLogPrefix(), requestedPrincipalCtx.getOperator(), p.getName()});
            PrincipalEvalPredicateFactory factory = requestedPrincipalCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), requestedPrincipalCtx.getOperator());
            if (factory != null) {
                PrincipalEvalPredicate predicate = factory.getPredicate(p);
                matches.clear();
                for (final Principal candidate : authenticationContext.getAuthenticationResult().getSupportedPrincipals(p.getClass())) {
                    if (!predicate.test((Object)new PrincipalSupportingComponent(){

                        public <T extends Principal> Set<T> getSupportedPrincipals(Class<T> c) {
                            return Collections.singleton(candidate);
                        }
                    })) continue;
                    this.log.debug("{} Principal '{}' in authentication result satisfies request for principal '{}'", new Object[]{this.getLogPrefix(), candidate.getName(), p.getName()});
                    matches.add(candidate);
                }
                if (matches.isEmpty()) continue;
                break;
            }
            this.log.warn("{} Configuration does not support requested principal evaluation with operator '{}' and type '{}'", new Object[]{this.getLogPrefix(), requestedPrincipalCtx.getOperator(), p.getClass()});
        }
        if (matches.isEmpty()) {
            return null;
        }
        AuthenticationFlowDescriptor flowDescriptor = (AuthenticationFlowDescriptor)authenticationContext.getAvailableFlows().get(authenticationContext.getAuthenticationResult().getAuthenticationFlowId());
        return flowDescriptor.getHighestWeighted(matches);
    }

    private boolean checkProxyRestrictions(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Subject subject) {
        Set<ProxyAuthenticationPrincipal> proxieds = subject.getPrincipals(ProxyAuthenticationPrincipal.class);
        if (proxieds == null || proxieds.isEmpty()) {
            return true;
        }
        for (ProxyAuthenticationPrincipal proxied : proxieds) {
            if (proxied.test(profileRequestContext)) continue;
            this.log.warn("{} Result contained a proxy restriction disallowing use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        return true;
    }
}

