/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.AttributeRule;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AttributeFilterPolicy
extends AbstractIdentifiedInitializableComponent
implements UnmodifiableComponent {
    private final Logger log = LoggerFactory.getLogger(AttributeFilterPolicy.class);
    private final PolicyRequirementRule rule;
    private final List<AttributeRule> valuePolicies;
    private String logPrefix;

    public AttributeFilterPolicy(@Nonnull @ParameterName(name="policyId") @NotEmpty String policyId, @Nonnull @ParameterName(name="requirementRule") PolicyRequirementRule requirementRule, @Nullable @ParameterName(name="attributeRules") @NonnullElements Collection<AttributeRule> attributeRules) {
        this.setId(policyId);
        this.rule = (PolicyRequirementRule)Constraint.isNotNull((Object)requirementRule, (String)"Attribute filter policy activiation criterion can not be null");
        this.valuePolicies = null != attributeRules ? List.copyOf(attributeRules) : Collections.emptyList();
    }

    @Nonnull
    public PolicyRequirementRule getPolicyRequirementRule() {
        return this.rule;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<AttributeRule> getAttributeRules() {
        return this.valuePolicies;
    }

    private boolean isApplicable(@Nonnull AttributeFilterContext filterContext) {
        this.log.debug("{} Checking if attribute filter policy is active", (Object)this.getLogPrefix());
        PolicyRequirementRule.Tristate isActive = this.rule.matches(filterContext);
        if (isActive == PolicyRequirementRule.Tristate.FAIL) {
            this.log.warn("{} Policy requirement rule failed for this request", (Object)this.getLogPrefix());
        } else if (isActive == PolicyRequirementRule.Tristate.TRUE) {
            this.log.debug("{} Policy is active for this request", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Policy is not active for this request", (Object)this.getLogPrefix());
        }
        return isActive == PolicyRequirementRule.Tristate.TRUE;
    }

    public void apply(@Nonnull AttributeFilterContext filterContext) throws AttributeFilterException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)((Object)filterContext), (String)"Attribute filter context can not be null");
        if (!this.isApplicable(filterContext)) {
            return;
        }
        Map<String, IdPAttribute> attributes = filterContext.getPrefilteredIdPAttributes();
        this.log.debug("{} Applying attribute filter policy to current set of attributes: {}", (Object)this.getLogPrefix(), attributes.keySet());
        for (AttributeRule valuePolicy : this.valuePolicies) {
            IdPAttribute attribute = attributes.get(valuePolicy.getAttributeId());
            if (attribute == null || attribute.getValues().isEmpty()) continue;
            valuePolicy.apply(attribute, filterContext);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    public String getLogPrefix() {
        String result = this.logPrefix;
        if (null == result) {
            this.logPrefix = result = new StringBuffer("Attribute Filter Policy '").append(this.getId()).append("' ").toString();
        }
        return result;
    }
}

