/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.context;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public final class AttributeContext
extends BaseContext {
    @Nonnull
    private Map<String, IdPAttribute> attributes;
    @Nullable
    private Map<String, IdPAttribute> unfilteredAttributes = Collections.emptyMap();
    private boolean consented;

    public AttributeContext() {
        this.attributes = Collections.emptyMap();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getIdPAttributes() {
        return this.attributes;
    }

    @Nonnull
    public AttributeContext setIdPAttributes(@Nullable @NonnullElements Collection<IdPAttribute> newAttributes) {
        this.attributes = newAttributes != null ? newAttributes.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteContext", (boolean)true))) : Collections.emptyMap();
        return this;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getUnfilteredIdPAttributes() {
        return this.unfilteredAttributes;
    }

    @Nonnull
    public AttributeContext setUnfilteredIdPAttributes(@Nullable @NonnullElements Collection<IdPAttribute> newAttributes) {
        this.unfilteredAttributes = null != this.unfilteredAttributes ? newAttributes.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteContextUnfiltered", (boolean)true))) : Collections.emptyMap();
        return this;
    }

    public boolean isConsented() {
        return this.consented;
    }

    @Nonnull
    public AttributeContext setConsented(boolean flag) {
        this.consented = flag;
        return this;
    }
}

