/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.okhttp3;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedExecutorService;
import io.opentracing.contrib.okhttp3.OkHttpClientSpanDecorator;
import io.opentracing.contrib.okhttp3.TagWrapper;
import io.opentracing.contrib.okhttp3.TracingCallFactory;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TracingInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(TracingInterceptor.class.getName());
    private Tracer tracer;
    private List<OkHttpClientSpanDecorator> decorators;

    public TracingInterceptor(Tracer tracer) {
        this(tracer, Collections.singletonList(OkHttpClientSpanDecorator.STANDARD_TAGS));
    }

    public TracingInterceptor(Tracer tracer, List<OkHttpClientSpanDecorator> decorators) {
        this.tracer = tracer;
        this.decorators = new ArrayList<OkHttpClientSpanDecorator>(decorators);
    }

    public static OkHttpClient addTracing(OkHttpClient.Builder builder, Tracer tracer) {
        return TracingInterceptor.addTracing(builder, tracer, Collections.singletonList(OkHttpClientSpanDecorator.STANDARD_TAGS));
    }

    public static OkHttpClient addTracing(OkHttpClient.Builder builder, Tracer tracer, List<OkHttpClientSpanDecorator> decorators) {
        TracingInterceptor tracingInterceptor = new TracingInterceptor(tracer, decorators);
        builder.interceptors().add(0, tracingInterceptor);
        builder.networkInterceptors().add(0, tracingInterceptor);
        builder.dispatcher(new Dispatcher((ExecutorService)new TracedExecutorService(Executors.newFixedThreadPool(10), tracer)));
        return builder.build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = null;
        if (chain.connection() == null) {
            Span span = this.tracer.buildSpan(chain.request().method()).withTag(Tags.COMPONENT.getKey(), "okhttp").start();
            Request.Builder requestBuilder = chain.request().newBuilder();
            Object tag = chain.request().tag();
            TagWrapper tagWrapper = tag instanceof TagWrapper ? (TagWrapper)tag : new TagWrapper(tag);
            requestBuilder.tag((Object)new TagWrapper(tagWrapper, span));
            try {
                response = chain.proceed(requestBuilder.build());
            }
            catch (Throwable ex) {
                for (OkHttpClientSpanDecorator spanDecorator : this.decorators) {
                    spanDecorator.onError(ex, span);
                }
                throw ex;
            }
            finally {
                span.finish();
            }
        } else {
            Object tag = chain.request().tag();
            if (tag instanceof TagWrapper) {
                TagWrapper tagWrapper = (TagWrapper)tag;
                response = new TracingCallFactory.NetworkInterceptor(this.tracer, tagWrapper.getSpan().context(), this.decorators).intercept(chain);
            } else {
                log.severe("tag is null or not an instance of TagWrapper, skipping decorator onResponse()");
            }
        }
        return response;
    }
}

