/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.okhttp3;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.okhttp3.OkHttpClientSpanDecorator;
import io.opentracing.contrib.okhttp3.RequestBuilderInjectAdapter;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TracingCallFactory
implements Call.Factory {
    static final String COMPONENT_NAME = "okhttp";
    private OkHttpClient okHttpClient;
    private Tracer tracer;
    private List<OkHttpClientSpanDecorator> decorators;

    public TracingCallFactory(OkHttpClient okHttpClient, Tracer tracer) {
        this(okHttpClient, tracer, Collections.singletonList(OkHttpClientSpanDecorator.STANDARD_TAGS));
    }

    public TracingCallFactory(OkHttpClient okHttpClient, Tracer tracer, List<OkHttpClientSpanDecorator> decorators) {
        this.okHttpClient = okHttpClient;
        this.tracer = tracer;
        this.decorators = new ArrayList<OkHttpClientSpanDecorator>(decorators);
    }

    public Call newCall(Request request) {
        final Span span = this.tracer.buildSpan(request.method()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).start();
        try {
            OkHttpClient.Builder okBuilder = this.okHttpClient.newBuilder();
            okBuilder.networkInterceptors().add(0, new NetworkInterceptor(this.tracer, span.context(), this.decorators));
            okBuilder.interceptors().add(0, new Interceptor(){

                /*
                 * Exception decompiling
                 */
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            return okBuilder.build().newCall(request);
        }
        catch (Exception ex) {
            for (OkHttpClientSpanDecorator spanDecorator : this.decorators) {
                spanDecorator.onError(ex, span);
            }
            throw ex;
        }
    }

    static /* synthetic */ Tracer access$000(TracingCallFactory x0) {
        return x0.tracer;
    }

    static /* synthetic */ List access$100(TracingCallFactory x0) {
        return x0.decorators;
    }

    static class NetworkInterceptor
    implements Interceptor {
        public SpanContext parentContext;
        public Tracer tracer;
        public List<OkHttpClientSpanDecorator> decorators;

        NetworkInterceptor(Tracer tracer, SpanContext spanContext, List<OkHttpClientSpanDecorator> decorators) {
            this.parentContext = spanContext;
            this.tracer = tracer;
            this.decorators = decorators;
        }

        /*
         * Loose catch block
         */
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Span networkSpan = this.tracer.buildSpan(chain.request().method()).withTag(Tags.SPAN_KIND.getKey(), "client").asChildOf(this.parentContext).start();
            for (OkHttpClientSpanDecorator spanDecorator : this.decorators) {
                spanDecorator.onRequest(chain.request(), networkSpan);
            }
            Request.Builder requestBuilder = chain.request().newBuilder();
            this.tracer.inject(networkSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new RequestBuilderInjectAdapter(requestBuilder));
            try {
                try (Scope scope = this.tracer.activateSpan(networkSpan);){
                    Response response = chain.proceed(requestBuilder.build());
                    for (OkHttpClientSpanDecorator spanDecorator : this.decorators) {
                        spanDecorator.onResponse(chain.connection(), response, networkSpan);
                    }
                    Response response2 = response;
                    return response2;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                networkSpan.finish();
            }
        }
    }
}

