/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.okhttp3;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Connection;
import okhttp3.Request;
import okhttp3.Response;

public interface OkHttpClientSpanDecorator {
    public static final OkHttpClientSpanDecorator STANDARD_TAGS = new OkHttpClientSpanDecorator(){

        @Override
        public void onRequest(Request request, Span span) {
            Tags.COMPONENT.set(span, "okhttp");
            Tags.HTTP_METHOD.set(span, request.method());
            Tags.HTTP_URL.set(span, request.url().toString());
        }

        @Override
        public void onError(Throwable throwable, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(this.errorLogs(throwable));
        }

        @Override
        public void onResponse(Connection connection, Response response, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(response.code()));
            InetAddress inetAddress = connection.socket().getInetAddress();
            Tags.PEER_HOSTNAME.set(span, inetAddress.getHostName());
            Tags.PEER_PORT.set(span, Integer.valueOf(connection.socket().getPort()));
            if (inetAddress instanceof Inet4Address) {
                byte[] address = inetAddress.getAddress();
                Tags.PEER_HOST_IPV4.set(span, Integer.valueOf(ByteBuffer.wrap(address).getInt()));
            } else {
                Tags.PEER_HOST_IPV6.set(span, inetAddress.toString());
            }
        }

        protected Map<String, Object> errorLogs(Throwable throwable) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", throwable);
            return errorLogs;
        }
    };

    public void onRequest(Request var1, Span var2);

    public void onError(Throwable var1, Span var2);

    public void onResponse(Connection var1, Response var2, Span var3);
}

