/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class SynchronousMetricStorage<T>
implements MetricStorage,
WriteableMetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T>> aggregatorLabels;
    private final ReentrantLock collectLock;
    private final Aggregator<T> aggregator;
    private final InstrumentProcessor<T> instrumentProcessor;
    private final AttributesProcessor attributesProcessor;
    private final BoundStorageHandle lateBoundStorageHandle = new BoundStorageHandle(){

        @Override
        public void release() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
            SynchronousMetricStorage.this.recordLong(value, attributes, context);
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
            SynchronousMetricStorage.this.recordDouble(value, attributes, context);
        }
    };

    public static <T> SynchronousMetricStorage<T> create(View view, InstrumentDescriptor instrumentDescriptor, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrumentDescriptor);
        Aggregator aggregator = view.getAggregation().config(instrumentDescriptor).create(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor);
        return new SynchronousMetricStorage(metricDescriptor, aggregator, new InstrumentProcessor(aggregator, startEpochNanos), view.getAttributesProcessor());
    }

    SynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, InstrumentProcessor<T> instrumentProcessor, AttributesProcessor attributesProcessor) {
        this.metricDescriptor = metricDescriptor;
        this.aggregatorLabels = new ConcurrentHashMap();
        this.collectLock = new ReentrantLock();
        this.aggregator = aggregator;
        this.instrumentProcessor = instrumentProcessor;
        this.attributesProcessor = attributesProcessor;
    }

    @Override
    public BoundStorageHandle bind(Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        if (this.attributesProcessor.usesContext()) {
            return this.lateBoundStorageHandle;
        }
        return this.doBind(this.attributesProcessor.process(attributes, Context.current()));
    }

    private BoundStorageHandle doBind(Attributes attributes) {
        AggregatorHandle<T> boundAggregatorHandle;
        AggregatorHandle<T> aggregatorHandle = this.aggregatorLabels.get(attributes);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while ((boundAggregatorHandle = this.aggregatorLabels.putIfAbsent(attributes, aggregatorHandle)) != null) {
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.aggregatorLabels.remove(attributes, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.doBind(attributes);
        try {
            handle.recordLong(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.doBind(attributes);
        try {
            handle.recordDouble(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricData collectAndReset(long startEpochNanos, long epochNanos) {
        this.collectLock.lock();
        try {
            for (Map.Entry<Attributes, AggregatorHandle<T>> entry : this.aggregatorLabels.entrySet()) {
                T accumulation;
                boolean unmappedEntry = entry.getValue().tryUnmap();
                if (unmappedEntry) {
                    this.aggregatorLabels.remove(entry.getKey(), entry.getValue());
                }
                if ((accumulation = entry.getValue().accumulateThenReset()) == null) continue;
                this.instrumentProcessor.batch(entry.getKey(), accumulation);
            }
            MetricData metricData = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

