/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.operation.impl;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import io.jans.orm.exception.KeyConversionException;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.model.AttributeType;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.sql.dsl.template.MariaDBJsonTemplates;
import io.jans.orm.sql.dsl.template.MySQLJsonTemplates;
import io.jans.orm.sql.dsl.template.PostgreSQLJsonTemplates;
import io.jans.orm.sql.model.TableMapping;
import io.jans.orm.sql.operation.SupportedDbType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectionProvider.class);
    private static final String MYSQL_QUERY_ENGINE_TYPE = "SELECT TABLE_NAME, ENGINE FROM information_schema.tables WHERE table_schema = ?";
    private static final String MYSQL_QUERY_CONSTRAINT_CHECK = "SELECT CONSTRAINT_SCHEMA AS TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME, CHECK_CLAUSE AS DEFINITION FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS WHERE CONSTRAINT_SCHEMA = ? ORDER BY TABLE_SCHEMA, TABLE_NAME";
    private static final String DRIVER_PROPERTIES_PREFIX = "connection.driver-property";
    private Properties props;
    private String connectionUri;
    private Properties connectionProperties;
    private GenericObjectPoolConfig<PoolableConnection> objectPoolConfig;
    private PoolingDataSource<PoolableConnection> poolingDataSource;
    private int creationResultCode;
    private ArrayList<String> binaryAttributes;
    private ArrayList<String> certificateAttributes;
    private PasswordEncryptionMethod passwordEncryptionMethod;
    private SupportedDbType dbType;
    private String dbVersion;
    private String schemaName;
    private SQLTemplates sqlTemplates;
    private SQLQueryFactory sqlQueryFactory;
    private Map<String, Map<String, AttributeType>> tableColumnsMap;
    private Map<String, String> tableEnginesMap = new HashMap<String, String>();
    private Map<String, ArrayList<String>> tableJsonColumnsMap = new HashMap<String, ArrayList<String>>();

    protected SqlConnectionProvider() {
    }

    public SqlConnectionProvider(Properties props) {
        this.props = props;
        this.tableColumnsMap = new HashMap<String, Map<String, AttributeType>>();
    }

    public void create() {
        try {
            this.init();
            this.initDsl();
        }
        catch (Exception ex) {
            this.creationResultCode = 1;
            Properties clonedProperties = (Properties)this.props.clone();
            if (clonedProperties.getProperty("auth.userName") != null) {
                clonedProperties.setProperty("auth.userPassword", "REDACTED");
            }
            LOG.error("Failed to create connection pool with properties: '{}'. Exception: {}", (Object)clonedProperties, (Object)ex);
        }
    }

    protected void init() throws Exception {
        String[] binaryAttrs;
        Boolean testOnReturn;
        Boolean testOnCreate;
        Integer cpMaxWaitTimeMillis;
        Integer cpMinIdle;
        Integer cpMaxIdle;
        if (!this.props.containsKey("db.schema.name")) {
            throw new ConfigurationException("Property 'db.schema.name' is mandatory!");
        }
        this.schemaName = this.props.getProperty("db.schema.name");
        if (!this.props.containsKey("connection.uri")) {
            throw new ConfigurationException("Property 'connection.uri' is mandatory!");
        }
        this.connectionUri = this.props.getProperty("connection.uri");
        Properties filteredDriverProperties = PropertiesHelper.findProperties((Properties)this.props, (String)DRIVER_PROPERTIES_PREFIX, (String)".");
        this.connectionProperties = new Properties();
        for (Map.Entry<Object, Object> driverPropertyEntry : filteredDriverProperties.entrySet()) {
            String key = StringHelper.toString((Object)driverPropertyEntry.getKey()).substring(DRIVER_PROPERTIES_PREFIX.length() + 1);
            String value = StringHelper.toString((Object)driverPropertyEntry.getValue());
            this.connectionProperties.put(key, value);
        }
        String userName = this.props.getProperty("auth.userName");
        String userPassword = this.props.getProperty("auth.userPassword");
        this.connectionProperties.setProperty("user", userName);
        this.connectionProperties.setProperty("password", userPassword);
        this.objectPoolConfig = new GenericObjectPoolConfig();
        Integer cpMaxTotal = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-total"), null);
        if (cpMaxTotal != null) {
            this.objectPoolConfig.setMaxTotal(cpMaxTotal.intValue());
        }
        if ((cpMaxIdle = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-idle"), null)) != null) {
            this.objectPoolConfig.setMaxIdle(cpMaxIdle.intValue());
        }
        if ((cpMinIdle = StringHelper.toInteger((String)this.props.getProperty("connection.pool.min-idle"), null)) != null) {
            this.objectPoolConfig.setMinIdle(cpMinIdle.intValue());
        }
        if ((cpMaxWaitTimeMillis = StringHelper.toInteger((String)this.props.getProperty("connection.pool.max-wait-time-millis"), null)) != null) {
            this.objectPoolConfig.setMaxWaitMillis((long)cpMaxWaitTimeMillis.intValue());
        }
        Integer cpMinEvictableIdleTimeMillis = StringHelper.toInteger((String)this.props.getProperty("connection.pool.min-evictable-idle-time-millis"), null);
        if (cpMaxWaitTimeMillis != null) {
            this.objectPoolConfig.setMinEvictableIdleTimeMillis((long)cpMinEvictableIdleTimeMillis.intValue());
        }
        if ((testOnCreate = StringHelper.toBoolean((String)this.props.getProperty("connection.pool.test-on-create"), null)) != null) {
            this.objectPoolConfig.setTestOnCreate(testOnCreate.booleanValue());
        }
        if ((testOnReturn = StringHelper.toBoolean((String)this.props.getProperty("connection.pool.test-on-return"), null)) != null) {
            this.objectPoolConfig.setTestOnReturn(testOnReturn.booleanValue());
        }
        this.openWithWaitImpl();
        LOG.info("Created connection pool");
        this.passwordEncryptionMethod = this.props.containsKey("password.encryption.method") ? PasswordEncryptionMethod.getMethod((String)this.props.getProperty("password.encryption.method")) : PasswordEncryptionMethod.HASH_METHOD_SHA256;
        this.binaryAttributes = new ArrayList();
        if (this.props.containsKey("binaryAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary attributes: '{}'", this.binaryAttributes);
        this.certificateAttributes = new ArrayList();
        if (this.props.containsKey("certificateAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("certificateAttributes").toString().toLowerCase(), (String)",");
            this.certificateAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary certificateAttributes: '{}'", this.certificateAttributes);
        try (Connection con = this.poolingDataSource.getConnection();){
            DatabaseMetaData databaseMetaData = con.getMetaData();
            String dbTypeString = databaseMetaData.getDatabaseProductName();
            this.dbType = SupportedDbType.resolveDbType(dbTypeString.toLowerCase());
            if (this.dbType == null) {
                throw new ConnectionException(String.format("Database type '%s' is not supported", dbTypeString));
            }
            this.dbVersion = databaseMetaData.getDatabaseProductVersion().toLowerCase();
            if (this.dbVersion != null && this.dbVersion.toLowerCase().contains("mariadb")) {
                this.dbType = SupportedDbType.MARIADB;
            }
            LOG.debug("Database product name: '{}'", (Object)this.dbType);
            this.loadTableMetaData(databaseMetaData, con);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to detect database product name and load metadata", (Throwable)ex);
        }
        this.creationResultCode = 0;
    }

    private void loadTableMetaData(DatabaseMetaData databaseMetaData, Connection con) throws SQLException {
        String tableName;
        ResultSet tableEnginesResultSet;
        PreparedStatement preparedStatement;
        long takes = System.currentTimeMillis();
        if (SupportedDbType.MYSQL == this.dbType) {
            LOG.info("Detecting engine types...");
            preparedStatement = con.prepareStatement(MYSQL_QUERY_ENGINE_TYPE);
            preparedStatement.setString(1, this.schemaName);
            tableEnginesResultSet = preparedStatement.executeQuery();
            try {
                while (tableEnginesResultSet.next()) {
                    tableName = tableEnginesResultSet.getString("TABLE_NAME");
                    String engineName = tableEnginesResultSet.getString("ENGINE");
                    this.tableEnginesMap.put(tableName, engineName);
                }
            }
            finally {
                if (tableEnginesResultSet != null) {
                    tableEnginesResultSet.close();
                }
            }
        }
        if (SupportedDbType.MARIADB == this.dbType) {
            LOG.info("Loading contrains to identify JSON columns ...");
            preparedStatement = con.prepareStatement(MYSQL_QUERY_CONSTRAINT_CHECK);
            preparedStatement.setString(1, this.schemaName);
            tableEnginesResultSet = preparedStatement.executeQuery();
            try {
                while (tableEnginesResultSet.next()) {
                    tableName = tableEnginesResultSet.getString("TABLE_NAME");
                    String constraintName = tableEnginesResultSet.getString("CONSTRAINT_NAME");
                    String definition = tableEnginesResultSet.getString("DEFINITION");
                    ArrayList<String> tableJsonColumns = this.tableJsonColumnsMap.get(tableName);
                    if (tableJsonColumns == null) {
                        tableJsonColumns = new ArrayList();
                        this.tableJsonColumnsMap.put(tableName, tableJsonColumns);
                    }
                    if (definition == null || !definition.toLowerCase().contains("json_valid")) continue;
                    tableJsonColumns.add(constraintName.toLowerCase());
                }
            }
            finally {
                if (tableEnginesResultSet != null) {
                    tableEnginesResultSet.close();
                }
            }
            LOG.debug("Found JSON constrains: '{}'.", this.tableJsonColumnsMap);
        }
        LOG.info("Scanning DB metadata...");
        try (ResultSet tableResultSet = databaseMetaData.getTables(null, this.schemaName, null, new String[]{"TABLE"});){
            while (tableResultSet.next()) {
                String tableName2 = tableResultSet.getString("TABLE_NAME");
                HashMap<String, AttributeType> tableColumns = new HashMap<String, AttributeType>();
                LOG.debug("Found table: '{}'.", (Object)tableName2);
                try (ResultSet columnResultSet = databaseMetaData.getColumns(null, this.schemaName, tableName2, null);){
                    while (columnResultSet.next()) {
                        ArrayList<String> tableJsonColumns;
                        String columnName = columnResultSet.getString("COLUMN_NAME").toLowerCase();
                        String columnTypeName = columnResultSet.getString("TYPE_NAME").toLowerCase();
                        if (SupportedDbType.MARIADB == this.dbType && "longtext".equalsIgnoreCase(columnTypeName) && (tableJsonColumns = this.tableJsonColumnsMap.get(tableName2)) != null && tableJsonColumns.contains(columnName)) {
                            columnTypeName = "json";
                        }
                        if ("jsonb".equalsIgnoreCase(columnTypeName)) {
                            columnTypeName = "jsonb";
                        }
                        boolean multiValued = "json".equals(columnTypeName) || "jsonb".equals(columnTypeName);
                        AttributeType attributeType = new AttributeType(columnName, columnTypeName, Boolean.valueOf(multiValued));
                        tableColumns.put(columnName, attributeType);
                    }
                }
                this.tableColumnsMap.put(StringHelper.toLowerCase((String)tableName2), tableColumns);
            }
        }
        takes = System.currentTimeMillis() - takes;
        LOG.info("Metadata scan finisehd in {} milliseconds", (Object)takes);
    }

    private void initDsl() throws SQLException {
        SQLTemplatesRegistry templatesRegistry = new SQLTemplatesRegistry();
        try (Connection con = this.poolingDataSource.getConnection();){
            DatabaseMetaData databaseMetaData = con.getMetaData();
            SQLTemplates.Builder sqlBuilder = templatesRegistry.getBuilder(databaseMetaData);
            if (SupportedDbType.MYSQL == this.dbType) {
                sqlBuilder = MySQLJsonTemplates.builder();
            } else if (SupportedDbType.MARIADB == this.dbType) {
                sqlBuilder = MariaDBJsonTemplates.builder();
            } else if (SupportedDbType.POSTGRESQL == this.dbType) {
                sqlBuilder = PostgreSQLJsonTemplates.builder().quote();
            }
            this.sqlTemplates = sqlBuilder.printSchema().build();
            Configuration configuration = new Configuration(this.sqlTemplates);
            this.sqlQueryFactory = new SQLQueryFactory(configuration, this.poolingDataSource);
        }
    }

    private void openWithWaitImpl() throws Exception {
        long connectionMaxWaitTimeMillis = StringHelper.toLong((String)this.props.getProperty("connection.pool.create-max-wait-time-millis"), (long)30000L);
        LOG.debug("Using connection timeout: '{}'", (Object)connectionMaxWaitTimeMillis);
        Exception lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + connectionMaxWaitTimeMillis;
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create connection pool: '{}'", (Object)attempt);
            }
            try {
                this.open();
                if (!this.isConnected()) {
                    LOG.info("Failed to connect to DB");
                    this.destroy();
                    throw new ConnectionException("Failed to create connection pool");
                }
            }
            catch (Exception ex) {
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void open() {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.connectionUri, this.connectionProperties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool objectPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, this.objectPoolConfig);
        this.poolingDataSource = new PoolingDataSource((ObjectPool)objectPool);
        poolableConnectionFactory.setPool((ObjectPool)objectPool);
    }

    public boolean destroy() {
        boolean result = true;
        if (this.poolingDataSource != null) {
            try {
                this.poolingDataSource.close();
            }
            catch (RuntimeException ex) {
                LOG.error("Failed to close connection pool", (Throwable)ex);
                result = false;
            }
            catch (SQLException ex) {
                LOG.error("Failed to close connection pool. Erorr code: '{}'", (Object)ex.getErrorCode(), (Object)ex);
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        boolean bl;
        block9: {
            if (this.poolingDataSource == null) {
                return false;
            }
            boolean isConnected = true;
            Connection con = this.poolingDataSource.getConnection();
            try {
                bl = con.isValid(30);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Failed to check connection", (Throwable)ex);
                    isConnected = false;
                    return isConnected;
                }
            }
            con.close();
        }
        return bl;
    }

    public int getCreationResultCode() {
        return this.creationResultCode;
    }

    public boolean isCreated() {
        return 0 == this.creationResultCode;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public ArrayList<String> getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }

    public boolean isCertificateAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.certificateAttributes.contains(attributeName.toLowerCase());
    }

    public PasswordEncryptionMethod getPasswordEncryptionMethod() {
        return this.passwordEncryptionMethod;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public SQLQueryFactory getSqlQueryFactory() {
        return this.sqlQueryFactory;
    }

    public TableMapping getTableMappingByKey(String key, String objectClass) {
        String tableName = objectClass;
        Map<String, AttributeType> columTypes = this.tableColumnsMap.get(StringHelper.toLowerCase((String)tableName));
        if ("_".equals(key)) {
            return new TableMapping("", tableName, objectClass, columTypes);
        }
        Object[] baseNameParts = key.split("_");
        if (ArrayHelper.isEmpty((Object[])baseNameParts)) {
            throw new KeyConversionException("Failed to determine base key part!");
        }
        TableMapping tableMapping = new TableMapping((String)baseNameParts[0], tableName, objectClass, columTypes);
        return tableMapping;
    }

    public String getEngineType(String objectClass) {
        String tableName = objectClass;
        return this.tableEnginesMap.get(tableName);
    }

    public Connection getConnection() {
        try {
            return this.poolingDataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new ConnectionException("Failed to get connection from pool", (Throwable)ex);
        }
    }

    public DatabaseMetaData getDatabaseMetaData() {
        DatabaseMetaData databaseMetaData;
        block8: {
            Connection con = this.poolingDataSource.getConnection();
            try {
                DatabaseMetaData databaseMetaData2;
                databaseMetaData = databaseMetaData2 = con.getMetaData();
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new ConnectionException("Failed to get database metadata", (Throwable)ex);
                }
            }
            con.close();
        }
        return databaseMetaData;
    }

    public SupportedDbType getDbType() {
        return this.dbType;
    }
}

