/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.NullExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.PredicateOperation;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.Expressions;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.model.AttributeType;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.sql.impl.SqlOps;
import io.jans.orm.sql.model.ConvertedExpression;
import io.jans.orm.sql.model.TableMapping;
import io.jans.orm.sql.operation.SqlOperationService;
import io.jans.orm.sql.operation.SupportedDbType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SqlFilterConverter.class);
    private static final LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private SqlOperationService operationService;
    private SupportedDbType dbType;
    private Path<String> stringDocAlias = ExpressionUtils.path(String.class, (String)"doc");
    private Path<Boolean> booleanDocAlias = ExpressionUtils.path(Boolean.class, (String)"doc");
    private Path<Integer> integerDocAlias = ExpressionUtils.path(Integer.class, (String)"doc");
    private Path<Long> longDocAlias = ExpressionUtils.path(Long.class, (String)"doc");
    private Path<Date> dateDocAlias = ExpressionUtils.path(Date.class, (String)"doc");
    private Path<Object> objectDocAlias = ExpressionUtils.path(Object.class, (String)"doc");
    public static String[] SPECIAL_REGEX_CHARACTERS = new String[]{"\\", "/", ".", "*", "+", "?", "|", "(", ")", "[", "]", "{", "}"};

    public SqlFilterConverter(SqlOperationService operationService) {
        this.operationService = operationService;
        this.dbType = operationService.getConnectionProvider().getDbType();
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, false);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, boolean skipAlias) throws SearchException {
        return this.convertToSqlFilter(tableMapping, genericFilter, propertiesAnnotationsMap, null, skipAlias);
    }

    public ConvertedExpression convertToSqlFilter(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        HashMap jsonAttributes = new HashMap();
        ConvertedExpression convertedExpression = this.convertToSqlFilterImpl(tableMapping, genericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
        return convertedExpression;
    }

    private ConvertedExpression convertToSqlFilterImpl(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        BooleanExpression expression;
        PredicateOperation operation;
        if (genericFilter == null) {
            return null;
        }
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to SQL convertion will be removed in new version!!!");
            currentGenericFilter = ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            type = currentGenericFilter.getType();
        }
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            Predicate[] expFilters = new Predicate[genericFilters.length];
            if (genericFilters != null) {
                Object isMultiValuedDetected;
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (int i = 0; i < genericFilters.length; ++i) {
                    Filter tmpFilter = genericFilters[i];
                    expFilters[i] = (Predicate)this.convertToSqlFilterImpl(tableMapping, tmpFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
                    if (!canJoinOrFilters) continue;
                    if (FilterType.EQUALITY != tmpFilter.getType() || tmpFilter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (tmpFilter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    isMultiValuedDetected = this.determineMultiValuedByType(tmpFilter.getAttributeName(), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected) && !Boolean.FALSE.equals(currentGenericFilter.getMultiValued())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = tmpFilter.getAttributeName();
                        joinOrFilters.add(tmpFilter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(tmpFilter.getAttributeName())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(tmpFilter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{expFilters[0]}), jsonAttributes);
                }
                if (FilterType.AND == type) {
                    return ConvertedExpression.build((Expression)ExpressionUtils.allOf((Predicate[])expFilters), jsonAttributes);
                }
                if (FilterType.OR == type) {
                    if (canJoinOrFilters) {
                        ArrayList<Object> rightObjs = new ArrayList<Object>(joinOrFilters.size());
                        Filter lastEqFilter = null;
                        isMultiValuedDetected = joinOrFilters.iterator();
                        while (isMultiValuedDetected.hasNext()) {
                            Filter eqFilter;
                            lastEqFilter = eqFilter = (Filter)isMultiValuedDetected.next();
                            Object assertionValue = eqFilter.getAssertionValue();
                            if (assertionValue instanceof AttributeEnum) {
                                assertionValue = ((AttributeEnum)assertionValue).getValue();
                            }
                            rightObjs.add(assertionValue);
                        }
                        return ConvertedExpression.build((Expression)ExpressionUtils.in((Expression)this.buildTypedPath(tableMapping, lastEqFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias), rightObjs), jsonAttributes);
                    }
                    return ConvertedExpression.build((Expression)ExpressionUtils.anyOf((Predicate[])expFilters), jsonAttributes);
                }
            }
        }
        boolean multiValued = this.isMultiValue(tableMapping, currentGenericFilter, propertiesAnnotationsMap);
        Expression columnExpression = this.buildTypedPath(tableMapping, currentGenericFilter, propertiesAnnotationsMap, jsonAttributes, processor, skipAlias);
        if (FilterType.EQUALITY == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    PredicateOperation operation2 = ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_CONTAINS, (Expression[])new Expression[]{columnExpression, this.buildTypedArrayExpression(tableMapping, currentGenericFilter)});
                    return ConvertedExpression.build((Expression)operation2, jsonAttributes);
                }
                PredicateOperation operation3 = ExpressionUtils.predicate((Operator)SqlOps.JSON_CONTAINS, (Expression[])new Expression[]{columnExpression, this.buildTypedArrayExpression(tableMapping, currentGenericFilter), Expressions.constant((Object)"$.v")});
                return ConvertedExpression.build((Expression)operation3, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)ExpressionUtils.eq((Expression)columnExpression, (Expression)this.buildTypedExpression(tableMapping, currentGenericFilter)), jsonAttributes);
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, columnExpression);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanExpression> expressions = new ArrayList<BooleanExpression>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)("$.v[" + i + "]"))});
                        BooleanExpression predicate = Expressions.asComparable((Expression)operation).loe(this.buildTypedExpression(tableMapping, currentGenericFilter));
                        expressions.add(predicate);
                    }
                    Predicate expression2 = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression2, jsonAttributes);
                }
                PredicateOperation operation4 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)"$.v[0]")});
                expression = Expressions.asComparable((Expression)operation4).loe(this.buildTypedExpression(tableMapping, currentGenericFilter));
                return ConvertedExpression.build((Expression)expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)columnExpression).loe(this.buildTypedExpression(tableMapping, currentGenericFilter)), jsonAttributes);
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, columnExpression);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanExpression> expressions = new ArrayList<BooleanExpression>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        operation = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)("$.v[" + i + "]"))});
                        BooleanExpression predicate = Expressions.asComparable((Expression)operation).goe(this.buildTypedExpression(tableMapping, currentGenericFilter));
                        expressions.add(predicate);
                    }
                    Predicate expression3 = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)expression3, jsonAttributes);
                }
                PredicateOperation operation5 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)"$.v[0]")});
                expression = Expressions.asComparable((Expression)operation5).goe(this.buildTypedExpression(tableMapping, currentGenericFilter));
                return ConvertedExpression.build((Expression)expression, jsonAttributes);
            }
            return ConvertedExpression.build((Expression)Expressions.asComparable((Expression)columnExpression).goe(this.buildTypedExpression(tableMapping, currentGenericFilter)), jsonAttributes);
        }
        if (FilterType.PRESENCE == type) {
            Expression expression4;
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    PredicateOperation operation6 = ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_NOT_EMPTY_ARRAY, (Expression[])new Expression[]{columnExpression});
                    return ConvertedExpression.build((Expression)operation6, jsonAttributes);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<Predicate> expressions = new ArrayList<Predicate>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        Predicate predicate = ExpressionUtils.isNotNull((Expression)ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)("$.v[" + i + "]"))}));
                        expressions.add(predicate);
                    }
                    Predicate predicate = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)predicate, jsonAttributes);
                }
                expression4 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)"$.v[0]")});
            } else {
                expression4 = columnExpression;
            }
            return ConvertedExpression.build((Expression)ExpressionUtils.isNotNull((Expression)expression4), jsonAttributes);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to SQL filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            Expression expression5;
            String matchChar = multiValued && SupportedDbType.POSTGRESQL == this.dbType ? ".*" : "%";
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                like.append(currentGenericFilter.getSubInitial());
            }
            like.append(matchChar);
            String[] subAny = currentGenericFilter.getSubAny();
            if (subAny != null && subAny.length > 0) {
                for (String any : subAny) {
                    if (SupportedDbType.POSTGRESQL == this.dbType) {
                        if (multiValued) {
                            like.append(this.escapeRegex(any));
                        } else {
                            like.append(any);
                        }
                    } else {
                        like.append(any);
                    }
                    like.append(matchChar);
                }
            }
            if (currentGenericFilter.getSubFinal() != null) {
                like.append(currentGenericFilter.getSubFinal());
            }
            if (multiValued) {
                if (SupportedDbType.POSTGRESQL == this.dbType) {
                    String likeString = "\"" + StringEscapeUtils.escapeJava((String)like.toString()) + "\"";
                    return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, columnExpression, Expressions.constant((Object)"like_regex"), likeString);
                }
                if (currentGenericFilter.getMultiValuedCount() > 1) {
                    ArrayList<BooleanOperation> expressions = new ArrayList<BooleanOperation>(currentGenericFilter.getMultiValuedCount());
                    for (int i = 0; i < currentGenericFilter.getMultiValuedCount(); ++i) {
                        PredicateOperation operation7 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)("$.v[" + i + "]"))});
                        BooleanOperation predicate = Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{operation7, Expressions.constant((Object)like.toString())});
                        expressions.add(predicate);
                    }
                    Predicate predicate = ExpressionUtils.anyOf(expressions);
                    return ConvertedExpression.build((Expression)predicate, jsonAttributes);
                }
                expression5 = ExpressionUtils.predicate((Operator)SqlOps.JSON_EXTRACT, (Expression[])new Expression[]{columnExpression, Expressions.constant((Object)"$.v[0]")});
            } else {
                expression5 = columnExpression;
            }
            return ConvertedExpression.build((Expression)Expressions.booleanOperation((Operator)Ops.LIKE, (Expression[])new Expression[]{expression5, Expressions.constant((Object)like.toString())}), jsonAttributes);
        }
        if (FilterType.LOWERCASE == type) {
            return ConvertedExpression.build(ExpressionUtils.toLower((Expression)columnExpression), jsonAttributes);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    private ConvertedExpression buildPostgreSqlMultivaluedComparisionExpression(TableMapping tableMapping, Map<String, Class<?>> jsonAttributes, Filter currentGenericFilter, Expression columnExpression) throws SearchException {
        Object typedArrayExpressionValue = this.prepareTypedArrayExpressionValue(tableMapping, currentGenericFilter);
        return this.buildPostgreSqlMultivaluedComparisionExpression(tableMapping, jsonAttributes, currentGenericFilter, columnExpression, Expressions.constant((Object)currentGenericFilter.getType().getSign()), typedArrayExpressionValue);
    }

    private ConvertedExpression buildPostgreSqlMultivaluedComparisionExpression(TableMapping tableMapping, Map<String, Class<?>> jsonAttributes, Filter currentGenericFilter, Expression columnExpression, Expression operationExpession, Object expressionValue) {
        NullExpression typedArrayExpression = expressionValue == null ? Expressions.nullExpression() : Expressions.constant((Object)expressionValue);
        PredicateOperation operation = ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_NOT_EMPTY_ARRAY, (Expression[])new Expression[]{ExpressionUtils.predicate((Operator)SqlOps.PGSQL_JSON_PATH_QUERY_ARRAY, (Expression[])new Expression[]{columnExpression, operationExpession, typedArrayExpression})});
        return ConvertedExpression.build((Expression)operation, jsonAttributes);
    }

    protected Boolean isMultiValue(TableMapping tableMapping, Filter filter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        String attributeName = filter.getAttributeName();
        AttributeType attributeType = null;
        if (StringHelper.isNotEmpty((String)attributeName) && (attributeType = this.getAttributeType(tableMapping, filter.getAttributeName())) == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", filter.getAttributeName()), new Object[0]));
        }
        if (attributeType == null && filter.getMultiValued() != null) {
            return filter.getMultiValued();
        }
        Boolean isMultiValuedDetected = this.determineMultiValuedByType(filter.getAttributeName(), propertiesAnnotationsMap);
        if ((Boolean.TRUE.equals(filter.getMultiValued()) || Boolean.TRUE.equals(isMultiValuedDetected)) && attributeType != null && Boolean.TRUE.equals(attributeType.getMultiValued())) {
            return true;
        }
        return false;
    }

    private AttributeType getAttributeType(TableMapping tableMapping, String attributeName) throws SearchException {
        if (tableMapping == null || attributeName == null) {
            return null;
        }
        String attributeNameLower = attributeName.toLowerCase();
        AttributeType attributeType = tableMapping.getColumTypes().get(attributeNameLower);
        if (attributeType == null) {
            throw new SearchException(String.format("Unknown column name '%s' in table/child table '%s'", attributeName, tableMapping.getTableName()));
        }
        return attributeType;
    }

    private String toInternalAttribute(Filter filter) {
        String attributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = (subFilter = filterArray[i]).getAttributeName())); ++i) {
            }
        }
        return this.toInternalAttribute(attributeName);
    }

    private String toInternalAttribute(String attributeName) {
        if (this.operationService == null) {
            return attributeName;
        }
        return this.operationService.toInternalAttribute(attributeName);
    }

    private Expression buildTypedExpression(TableMapping tableMapping, Filter filter) throws SearchException {
        Object expressionValue = this.prepareTypedExpressionValue(tableMapping, filter);
        NullExpression expression = expressionValue == null ? Expressions.nullExpression() : Expressions.constant((Object)expressionValue);
        return expression;
    }

    private Expression buildTypedArrayExpression(TableMapping tableMapping, Filter filter) throws SearchException {
        Object assertionValue = this.prepareTypedArrayExpressionValue(tableMapping, filter);
        String assertionValueJson = this.convertValueToJson(Arrays.asList(assertionValue));
        return Expressions.constant((Object)assertionValueJson);
    }

    private Object prepareTypedArrayExpressionValue(TableMapping tableMapping, Filter filter) throws SearchException {
        Object assertionValue = this.prepareTypedExpressionValue(tableMapping, filter);
        if (assertionValue instanceof Date) {
            assertionValue = this.operationService.encodeTime((Date)assertionValue);
        }
        return assertionValue;
    }

    private Object prepareTypedExpressionValue(TableMapping tableMapping, Filter filter) throws SearchException {
        AttributeType attributeType = null;
        if (StringHelper.isNotEmpty((String)filter.getAttributeName()) && (attributeType = this.getAttributeType(tableMapping, filter.getAttributeName())) == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", filter.getAttributeName()), new Object[0]));
        }
        Object assertionValue = filter.getAssertionValue();
        if (assertionValue instanceof AttributeEnum) {
            assertionValue = ((AttributeEnum)assertionValue).getValue();
        } else if (assertionValue instanceof String) {
            Date dateValue;
            if (attributeType != null && "timestamp".equals(attributeType.getType()) && (dateValue = this.operationService.decodeTime((String)assertionValue, true)) != null) {
                assertionValue = dateValue;
            }
            try {
                String columnType;
                JDBCType jdbcType;
                if (attributeType != null && (jdbcType = JDBCType.valueOf(StringHelper.toUpperCase((String)(columnType = attributeType.getType())))) == JDBCType.SMALLINT && (StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"true") || StringHelper.equalsIgnoreCase((String)((String)assertionValue), (String)"1"))) {
                    assertionValue = 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return assertionValue;
    }

    private Expression buildTypedPath(TableMapping tableMapping, Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Map<String, Class<?>> jsonAttributes, Function<? super Filter, Boolean> processor, boolean skipAlias) throws SearchException {
        boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
        if (hasSubFilters) {
            return this.convertToSqlFilterImpl(tableMapping, genericFilter.getFilters()[0], propertiesAnnotationsMap, jsonAttributes, processor, skipAlias).expression();
        }
        String internalAttribute = this.toInternalAttribute(genericFilter);
        return this.buildTypedPath(tableMapping, genericFilter, internalAttribute, skipAlias);
    }

    private Expression buildTypedPath(TableMapping tableMapping, Filter filter, String attributeName, boolean skipAlias) throws SearchException {
        AttributeType attributeType = this.getAttributeType(tableMapping, filter.getAttributeName());
        if (attributeType == null && tableMapping != null) {
            throw new SearchException(String.format(String.format("Failed to find attribute type for '%s'", filter.getAttributeName()), new Object[0]));
        }
        if (attributeType != null && "timestamp".equals(attributeType.getType())) {
            if (skipAlias) {
                return Expressions.dateTimePath(Date.class, (String)attributeName);
            }
            return Expressions.dateTimePath(Date.class, this.dateDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof String) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.stringDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Boolean) {
            if (skipAlias) {
                return Expressions.booleanPath((String)attributeName);
            }
            return Expressions.booleanPath(this.booleanDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Integer) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.integerDocAlias, (String)attributeName);
        }
        if (filter.getAssertionValue() instanceof Long) {
            if (skipAlias) {
                return Expressions.stringPath((String)attributeName);
            }
            return Expressions.stringPath(this.longDocAlias, (String)attributeName);
        }
        if (skipAlias) {
            return Expressions.stringPath((String)attributeName);
        }
        return Expressions.stringPath(this.objectDocAlias, (String)attributeName);
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(Object[].class) || parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    protected String convertValueToJson(Object propertyValue) throws SearchException {
        try {
            String value = JSON_OBJECT_MAPPER.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new SearchException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }

    private Object escapeRegex(String str) {
        String result = str;
        for (String ch : SPECIAL_REGEX_CHARACTERS) {
            result = result.replace(ch, "\\" + ch);
        }
        return result;
    }
}

