/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.sql.dsl.template;

import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.types.Type;
import io.jans.orm.sql.dsl.types.PostgreSQLJsonType;
import io.jans.orm.sql.impl.SqlOps;

public class PostgreSQLJsonTemplates
extends PostgreSQLTemplates {
    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            protected SQLTemplates build(char escape, boolean quote) {
                return new PostgreSQLJsonTemplates(escape, quote);
            }
        };
    }

    public PostgreSQLJsonTemplates(char escape, boolean quote) {
        super(escape, quote);
        this.addCustomType((Type)new PostgreSQLJsonType());
        this.add(SqlOps.PGSQL_JSON_CONTAINS, "{0} @> {1}::jsonb");
        this.add(SqlOps.PGSQL_JSON_PATH_QUERY_ARRAY, "jsonb_path_query_array({0}, CONCAT('$[*] ? (@', {1}, {2}, ')')::jsonpath)");
        this.add(SqlOps.PGSQL_JSON_NOT_EMPTY_ARRAY, "jsonb_array_length({0}) > 0");
    }
}

