/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.search.filter;

import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.util.StringHelper;
import java.util.LinkedList;

public class FilterProcessor {
    public static final Filter OBJECT_CLASS_EQUALITY_FILTER = Filter.createEqualityFilter("objectClass", null);
    public static final Filter OBJECT_CLASS_PRESENCE_FILTER = Filter.createPresenceFilter("objectClass");

    public Filter excludeFilter(Filter genericFilter, Filter ... excludeFilters) {
        if (genericFilter == null) {
            return null;
        }
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            return genericFilter;
        }
        Filter[] filters = genericFilter.getFilters();
        if (filters != null) {
            LinkedList<Filter> resultFilters = new LinkedList<Filter>();
            for (Filter filter : filters) {
                Filter resultFilter = this.excludeFilter(filter, excludeFilters);
                if (resultFilter == null) continue;
                resultFilters.add(resultFilter);
            }
            if (resultFilters.size() == 0) {
                return null;
            }
            Filter resultFilter = genericFilter.clone();
            resultFilter.setFilters(resultFilters.toArray(new Filter[0]));
            return resultFilter;
        }
        for (Filter excludeFilter : excludeFilters) {
            boolean valueMatch;
            boolean typeMatch = excludeFilter.getType() == null || excludeFilter.getType() == type;
            boolean nameMatch = StringHelper.isEmpty((String)excludeFilter.getAttributeName()) || StringHelper.equalsIgnoreCase((String)excludeFilter.getAttributeName(), (String)genericFilter.getAttributeName());
            boolean bl = valueMatch = StringHelper.isEmptyString((Object)excludeFilter.getAssertionValue()) || excludeFilter.getAssertionValue().equals(genericFilter.getAssertionValue());
            if (!typeMatch || !nameMatch || !valueMatch) continue;
            return null;
        }
        return genericFilter;
    }
}

