/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.operation.impl;

import com.couchbase.client.core.diagnostics.EndpointPingReport;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.PingState;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.manager.bucket.BucketManager;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryStatus;
import io.jans.orm.couchbase.model.BucketMapping;
import io.jans.orm.exception.KeyConversionException;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    private Properties props;
    private String connectionString;
    private String[] buckets;
    private String defaultBucket;
    private String userName;
    private String userPassword;
    private ClusterEnvironment clusterEnvironment;
    private Cluster cluster;
    private int creationResultCode;
    private HashMap<String, BucketMapping> bucketToBaseNameMapping;
    private HashMap<String, BucketMapping> baseNameToBucketMapping;
    private BucketMapping defaultBucketMapping;
    private ArrayList<String> binaryAttributes;
    private ArrayList<String> certificateAttributes;
    private PasswordEncryptionMethod passwordEncryptionMethod;

    protected CouchbaseConnectionProvider() {
    }

    public CouchbaseConnectionProvider(Properties props, ClusterEnvironment clusterEnvironment) {
        this.props = props;
        this.clusterEnvironment = clusterEnvironment;
    }

    public void create() {
        try {
            this.init();
        }
        catch (Exception ex) {
            this.creationResultCode = 1;
            Properties clonedProperties = (Properties)this.props.clone();
            if (clonedProperties.getProperty("auth.userName") != null) {
                clonedProperties.setProperty("auth.userPassword", "REDACTED");
            }
            LOG.error("Failed to create connection with properties: '{}'. Exception: {}", (Object)clonedProperties, (Object)ex);
            ex.printStackTrace();
        }
    }

    protected void init() {
        String[] binaryAttrs;
        this.connectionString = this.props.getProperty("servers");
        this.userName = this.props.getProperty("auth.userName");
        this.userPassword = this.props.getProperty("auth.userPassword");
        this.defaultBucket = this.props.getProperty("bucket.default", null);
        if (StringHelper.isEmpty((String)this.defaultBucket)) {
            throw new ConfigurationException("Default bucket is not defined!");
        }
        this.buckets = StringHelper.split((String)this.props.getProperty("buckets"), (String)",");
        if (!Arrays.asList(this.buckets).contains(this.defaultBucket)) {
            this.buckets = ArrayHelper.addItemToStringArray((String[])this.buckets, (String)this.defaultBucket);
        }
        this.openWithWaitImpl();
        LOG.info("Opended: '{}' buket with base names: '{}'", this.bucketToBaseNameMapping.keySet(), this.baseNameToBucketMapping.keySet());
        this.passwordEncryptionMethod = this.props.containsKey("password.encryption.method") ? PasswordEncryptionMethod.getMethod((String)this.props.getProperty("password.encryption.method")) : PasswordEncryptionMethod.HASH_METHOD_SHA256;
        this.binaryAttributes = new ArrayList();
        if (this.props.containsKey("binaryAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary attributes: '{}'", this.binaryAttributes);
        this.certificateAttributes = new ArrayList();
        if (this.props.containsKey("certificateAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("certificateAttributes").toString().toLowerCase(), (String)",");
            this.certificateAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary certificateAttributes: '{}'", this.certificateAttributes);
        this.creationResultCode = 0;
    }

    private void openWithWaitImpl() {
        String connectionMaxWaitTime = this.props.getProperty("connection.connection-max-wait-time");
        int connectionMaxWaitTimeSeconds = 30;
        if (StringHelper.isNotEmpty((String)connectionMaxWaitTime)) {
            connectionMaxWaitTimeSeconds = Integer.parseInt(connectionMaxWaitTime);
        }
        LOG.debug("Using Couchbase connection timeout: '{}'", (Object)connectionMaxWaitTimeSeconds);
        CouchbaseException lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + (long)(connectionMaxWaitTimeSeconds * 1000);
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create connection: '{}'", (Object)attempt);
            }
            try {
                this.open();
                if (!this.isConnected()) {
                    LOG.info("Failed to connect to Couchbase");
                    this.destroy();
                    throw new CouchbaseException("Failed to create connection");
                }
            }
            catch (CouchbaseException ex) {
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void open() {
        this.bucketToBaseNameMapping = new HashMap();
        this.baseNameToBucketMapping = new HashMap();
        ClusterOptions clusterOptions = ClusterOptions.clusterOptions((String)this.userName, (String)this.userPassword);
        if (this.clusterEnvironment != null) {
            clusterOptions.environment(this.clusterEnvironment);
        }
        this.cluster = Cluster.connect((String)this.connectionString, (ClusterOptions)clusterOptions);
        for (String bucketName : this.buckets) {
            String baseNamesProp = this.props.getProperty(String.format("bucket.%s.mapping", bucketName), "");
            String[] baseNames = StringHelper.split((String)baseNamesProp, (String)",");
            Bucket bucket = this.cluster.bucket(bucketName);
            BucketMapping bucketMapping = new BucketMapping(bucketName, bucket);
            this.bucketToBaseNameMapping.put(bucketName, bucketMapping);
            for (String baseName : baseNames) {
                this.baseNameToBucketMapping.put(baseName, bucketMapping);
            }
            if (!StringHelper.equalsIgnoreCase((String)bucketName, (String)this.defaultBucket)) continue;
            this.defaultBucketMapping = bucketMapping;
        }
    }

    public boolean destroy() {
        if (this.cluster != null) {
            this.cluster.disconnect();
        }
        return true;
    }

    public boolean isConnected() {
        if (this.cluster == null) {
            return false;
        }
        boolean isConnected = true;
        try {
            for (BucketMapping bucketMapping : this.bucketToBaseNameMapping.values()) {
                if (this.isConnected(bucketMapping)) continue;
                LOG.error("Bucket '{}' is in invalid state", (Object)bucketMapping.getBucketName());
                isConnected = false;
                break;
            }
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to check bucket", (Throwable)ex);
            isConnected = false;
        }
        return isConnected;
    }

    private boolean isConnected(BucketMapping bucketMapping) {
        Bucket bucket = bucketMapping.getBucket();
        BucketManager bucketManager = this.cluster.buckets();
        BucketSettings bucketSettings = bucketManager.getBucket(bucket.name());
        boolean result = true;
        if (BucketType.COUCHBASE == bucketSettings.bucketType()) {
            QueryResult queryResult = this.cluster.query("SELECT state FROM system:indexes WHERE state != $1 AND keyspace_id = $2", QueryOptions.queryOptions().parameters(JsonArray.from((Object[])new Object[]{"online", bucket.name()})));
            if (QueryStatus.SUCCESS == queryResult.metaData().status()) {
                boolean bl = result = queryResult.rowsAsObject().size() == 0;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("There are indexes which not online");
                }
            } else {
                result = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Faield to check indexes status");
                }
            }
        }
        if (result) {
            PingResult pingResult = bucket.ping();
            block0: for (Map.Entry pingResultEntry : pingResult.endpoints().entrySet()) {
                for (EndpointPingReport endpointPingReport : (List)pingResultEntry.getValue()) {
                    if (PingState.OK == endpointPingReport.state()) continue;
                    LOG.debug("Ping returns that service type {} is not online", (Object)endpointPingReport.type());
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public BucketMapping getBucketMapping(String baseName) {
        BucketMapping bucketMapping = this.baseNameToBucketMapping.get(baseName);
        if (bucketMapping == null) {
            return null;
        }
        return bucketMapping;
    }

    public BucketMapping getBucketMappingByKey(String key) {
        if ("_".equals(key)) {
            return this.defaultBucketMapping;
        }
        Object[] baseNameParts = key.split("_");
        if (ArrayHelper.isEmpty((Object[])baseNameParts)) {
            throw new KeyConversionException("Failed to determine base key part!");
        }
        BucketMapping bucketMapping = this.baseNameToBucketMapping.get(baseNameParts[0]);
        if (bucketMapping != null) {
            return bucketMapping;
        }
        return this.defaultBucketMapping;
    }

    public int getCreationResultCode() {
        return this.creationResultCode;
    }

    public boolean isCreated() {
        return 0 == this.creationResultCode;
    }

    public String getServers() {
        return this.connectionString;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public ArrayList<String> getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }

    public boolean isCertificateAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.certificateAttributes.contains(attributeName.toLowerCase());
    }

    public PasswordEncryptionMethod getPasswordEncryptionMethod() {
        return this.passwordEncryptionMethod;
    }
}

