/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.impl;

import com.couchbase.client.java.json.JsonObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.couchbase.model.ConvertedExpression;
import io.jans.orm.couchbase.operation.CouchbaseOperationService;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.util.ReflectHelper;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseFilterConverter.class);
    private LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private CouchbaseOperationService operationService;

    public CouchbaseFilterConverter(CouchbaseOperationService operationService) {
        this.operationService = operationService;
    }

    public ConvertedExpression convertToCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToCouchbaseFilter(genericFilter, propertiesAnnotationsMap, null);
    }

    public ConvertedExpression convertToCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor) throws SearchException {
        JsonObject queryParameters = JsonObject.create();
        return this.convertToCouchbaseFilter(genericFilter, propertiesAnnotationsMap, queryParameters, processor);
    }

    public ConvertedExpression convertToCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, JsonObject queryParameters, Function<? super Filter, Boolean> processor) throws SearchException {
        String result;
        String leftExpressionPart;
        CharSequence result2;
        if (genericFilter == null) {
            return null;
        }
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to N1QL convertion will be removed in new version!!!");
            currentGenericFilter = this.ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            LOG.debug(String.format("Converted RAW filter: %s", currentGenericFilter));
            type = currentGenericFilter.getType();
        }
        boolean requiredConsistency = this.isRequiredConsistency(currentGenericFilter, propertiesAnnotationsMap);
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            ConvertedExpression[] expFilters = new ConvertedExpression[genericFilters.length];
            if (genericFilters != null) {
                int i;
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (i = 0; i < genericFilters.length; ++i) {
                    Filter tmpFilter = genericFilters[i];
                    expFilters[i] = this.convertToCouchbaseFilter(tmpFilter, propertiesAnnotationsMap, queryParameters, processor);
                    if (!canJoinOrFilters) continue;
                    if (FilterType.EQUALITY != tmpFilter.getType() || tmpFilter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (tmpFilter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    Boolean isMultiValuedDetected = this.determineMultiValuedByType(tmpFilter.getAttributeName(), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected) && !Boolean.FALSE.equals(currentGenericFilter.getMultiValued())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = tmpFilter.getAttributeName();
                        joinOrFilters.add(tmpFilter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(tmpFilter.getAttributeName())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(tmpFilter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build("NOT ( " + expFilters[0].expression() + " )", queryParameters, expFilters[0].consistency());
                }
                if (FilterType.AND == type) {
                    for (i = 0; i < expFilters.length; ++i) {
                        requiredConsistency |= expFilters[i].consistency();
                    }
                    StringBuilder result3 = new StringBuilder("( ").append(expFilters[0].expression());
                    for (int i2 = 1; i2 < expFilters.length; ++i2) {
                        result3 = result3.append(" AND ").append(expFilters[i2].expression());
                    }
                    result3.append(" )");
                    return ConvertedExpression.build(result3.toString(), queryParameters, requiredConsistency);
                }
                if (FilterType.OR == type) {
                    for (i = 0; i < expFilters.length; ++i) {
                        requiredConsistency |= expFilters[i].consistency();
                    }
                    if (canJoinOrFilters) {
                        ArrayList<String> assertionValues = new ArrayList<String>();
                        for (ConvertedExpression eqFilter : expFilters) {
                            assertionValues.addAll(eqFilter.getSingleLevelParameters());
                        }
                        result2 = new StringBuilder(this.buildLeftExpressionPart(genericFilters[0], false, propertiesAnnotationsMap, queryParameters, processor)).append(" IN [ $").append(assertionValues.get(0));
                        for (int i3 = 1; i3 < assertionValues.size(); ++i3) {
                            Object assertionValue = assertionValues.get(i3);
                            ((StringBuilder)result2).append(", $").append(assertionValue);
                        }
                        ((StringBuilder)result2).append(" ]");
                        return ConvertedExpression.build(((StringBuilder)result2).toString(), queryParameters, requiredConsistency);
                    }
                    StringBuilder result4 = new StringBuilder("( ").append(expFilters[0].expression());
                    for (int i4 = 1; i4 < expFilters.length; ++i4) {
                        result4 = result4.append(" OR ").append(expFilters[i4].expression());
                    }
                    result4.append(" )");
                    return ConvertedExpression.build(result4.toString(), queryParameters, requiredConsistency);
                }
            }
        }
        Boolean multiValuedWithUnknown = this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap);
        boolean multiValued = Boolean.TRUE.equals(multiValuedWithUnknown);
        String internalAttribute = this.toInternalAttribute(currentGenericFilter);
        if (FilterType.EQUALITY == type || FilterType.LESS_OR_EQUAL == type || FilterType.GREATER_OR_EQUAL == type) {
            String variableExpression = this.buildVariableExpression(internalAttribute, multiValued, currentGenericFilter.getAssertionValue(), queryParameters);
            String leftExpressionPart2 = this.buildLeftExpressionPart(currentGenericFilter, multiValued, propertiesAnnotationsMap, queryParameters, processor);
            if (multiValued) {
                String result5 = String.format("ANY %s_ IN %s SATISFIES %s %s $%s END", internalAttribute, internalAttribute, leftExpressionPart2, type.getSign(), variableExpression);
                return ConvertedExpression.build(result5, queryParameters, variableExpression, requiredConsistency);
            }
            boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
            if (FilterType.EQUALITY == type) {
                if (Boolean.FALSE.equals(multiValuedWithUnknown) || hasSubFilters && multiValuedWithUnknown == null) {
                    result2 = String.format("%s %s $%s", leftExpressionPart2, type.getSign(), variableExpression);
                    return ConvertedExpression.build((String)result2, queryParameters, variableExpression, requiredConsistency);
                }
                result2 = String.format("( ( %s = $%s ) OR ( $%s IN %s ) )", leftExpressionPart2, variableExpression, variableExpression, internalAttribute);
                return ConvertedExpression.build((String)result2, queryParameters, variableExpression, requiredConsistency);
            }
            result2 = String.format("%s %s $%s", leftExpressionPart2, type.getSign(), variableExpression);
            return ConvertedExpression.build((String)result2, queryParameters, variableExpression, requiredConsistency);
        }
        if (FilterType.PRESENCE == type) {
            leftExpressionPart = this.buildLeftExpressionPart(currentGenericFilter, multiValued, propertiesAnnotationsMap, queryParameters, processor);
            if (multiValued) {
                result = String.format("ANY %s_ IN %s SATISFIES %s IS NOT MISSING END", internalAttribute, internalAttribute, leftExpressionPart);
                return ConvertedExpression.build(result, queryParameters, requiredConsistency);
            }
            result = String.format("%s IS NOT MISSING", leftExpressionPart);
            return ConvertedExpression.build(result, queryParameters, requiredConsistency);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to Couchbase filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            String result6;
            String[] subAny;
            leftExpressionPart = this.buildLeftExpressionPart(currentGenericFilter, multiValued, propertiesAnnotationsMap, queryParameters, processor);
            HashSet<String> filterParameters = new HashSet<String>();
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                String subInital = currentGenericFilter.getSubInitial() + "%";
                String variableExpressionInitial = this.buildVariableExpression(internalAttribute + "_i", multiValued, subInital, queryParameters);
                filterParameters.add(variableExpressionInitial);
                like.append("$" + variableExpressionInitial);
            }
            if ((subAny = currentGenericFilter.getSubAny()) != null && subAny.length > 0) {
                StringBuilder anyBuilder = new StringBuilder("%");
                for (String any : subAny) {
                    anyBuilder.append(any);
                    anyBuilder.append("%");
                }
                String variableExpressionAny = this.buildVariableExpression(internalAttribute + "_any", multiValued, anyBuilder.toString(), queryParameters);
                like.append("$" + variableExpressionAny);
                filterParameters.add(variableExpressionAny);
            }
            if (currentGenericFilter.getSubFinal() != null) {
                String subFinal = "%" + currentGenericFilter.getSubFinal();
                String variableExpressionFinal = this.buildVariableExpression(internalAttribute + "_f", multiValued, subFinal, queryParameters);
                filterParameters.add(variableExpressionFinal);
                like.append("$" + variableExpressionFinal);
            }
            if (multiValued) {
                result6 = String.format("ANY %s_ IN %s SATISFIES %s LIKE %s END", internalAttribute, internalAttribute, leftExpressionPart, like.toString());
                ConvertedExpression convertedExpression = ConvertedExpression.build(result6, queryParameters, requiredConsistency);
                convertedExpression.getSingleLevelParameters().addAll(filterParameters);
                return convertedExpression;
            }
            result6 = String.format("%s LIKE %s", leftExpressionPart, like.toString());
            return ConvertedExpression.build(result6, queryParameters, requiredConsistency);
        }
        if (FilterType.LOWERCASE == type) {
            leftExpressionPart = this.buildLeftExpressionPart(currentGenericFilter, multiValued, propertiesAnnotationsMap, queryParameters, processor);
            result = String.format("LOWER( %s )", leftExpressionPart);
            return ConvertedExpression.build(result, queryParameters, requiredConsistency);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    protected Boolean isMultiValue(Filter currentGenericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        Boolean isMultiValuedDetected = this.determineMultiValuedByType(currentGenericFilter.getAttributeName(), propertiesAnnotationsMap);
        if (Boolean.TRUE.equals(currentGenericFilter.getMultiValued()) || Boolean.TRUE.equals(isMultiValuedDetected)) {
            return true;
        }
        if (Boolean.FALSE.equals(currentGenericFilter.getMultiValued()) || Boolean.FALSE.equals(isMultiValuedDetected)) {
            return false;
        }
        return null;
    }

    private String toInternalAttribute(Filter filter) {
        String attributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = (subFilter = filterArray[i]).getAttributeName())); ++i) {
            }
        }
        if (this.operationService == null) {
            return attributeName;
        }
        return this.operationService.toInternalAttribute(attributeName);
    }

    private String buildVariableExpression(String attributeName, boolean multiValued, Object assertionValue, JsonObject queryParameters) throws SearchException {
        String usedAttributeName = attributeName;
        int idx = 0;
        while (queryParameters.containsKey(usedAttributeName) && idx < 100) {
            usedAttributeName = "_" + attributeName + "_" + Integer.toString(idx++);
        }
        if (multiValued) {
            this.addQueryParameter(assertionValue, queryParameters, usedAttributeName);
        } else {
            this.addQueryParameter(assertionValue, queryParameters, usedAttributeName);
        }
        return usedAttributeName;
    }

    private void addQueryParameter(Object assertionValue, JsonObject queryParameters, String usedAttributeName) {
        if (assertionValue instanceof AttributeEnum) {
            queryParameters.put(usedAttributeName, ((AttributeEnum)assertionValue).getValue());
        } else if (assertionValue instanceof Boolean) {
            queryParameters.put(usedAttributeName, (Object)((Boolean)assertionValue));
        } else if (assertionValue instanceof Integer) {
            queryParameters.put(usedAttributeName, (Number)((Integer)assertionValue));
        } else if (assertionValue instanceof Long) {
            queryParameters.put(usedAttributeName, (Number)((Long)assertionValue));
        } else if (assertionValue instanceof Long) {
            queryParameters.put(usedAttributeName, (Number)((Long)assertionValue));
        } else if (assertionValue instanceof Date) {
            queryParameters.put(usedAttributeName, this.operationService.encodeTime((Date)assertionValue));
        } else {
            queryParameters.put(usedAttributeName, assertionValue);
        }
    }

    private String buildLeftExpressionPart(Filter genericFilter, boolean multiValued, Map<String, PropertyAnnotation> propertiesAnnotationsMap, JsonObject queryParameters, Function<? super Filter, Boolean> processor) throws SearchException {
        boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])genericFilter.getFilters());
        String internalAttribute = this.toInternalAttribute(genericFilter);
        String innerExpression = null;
        if (multiValued) {
            if (hasSubFilters) {
                Filter subFilter = genericFilter.getFilters()[0].clone();
                subFilter.setAttributeName(internalAttribute + "_");
                innerExpression = this.convertToCouchbaseFilter(subFilter, propertiesAnnotationsMap, queryParameters, processor).expression();
            } else {
                innerExpression = internalAttribute + "_";
            }
        } else if (hasSubFilters) {
            Filter subFilter = genericFilter.getFilters()[0];
            innerExpression = this.convertToCouchbaseFilter(subFilter, propertiesAnnotationsMap, queryParameters, processor).expression();
        } else {
            innerExpression = internalAttribute;
        }
        return innerExpression;
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    private boolean isRequiredConsistency(Filter filter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (propertiesAnnotationsMap == null) {
            return false;
        }
        String attributeName = filter.getAttributeName();
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return false;
        }
        AttributeName attributeNameAnnotation = (AttributeName)ReflectHelper.getAnnotationByType((List)propertyAnnotation.getAnnotations(), AttributeName.class);
        return attributeNameAnnotation.consistency();
    }

    protected String convertValueToJson(Object propertyValue) throws SearchException {
        try {
            String value = JSON_OBJECT_MAPPER.writeValueAsString(propertyValue);
            return value;
        }
        catch (Exception ex) {
            LOG.error("Failed to convert '{}' to json value:", propertyValue, (Object)ex);
            throw new SearchException(String.format("Failed to convert '%s' to json value", propertyValue));
        }
    }
}

