/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.reflect.property;

import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.exception.PropertyAccessException;
import io.jans.orm.exception.PropertyNotFoundException;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.PropertyAccessor;
import io.jans.orm.reflect.property.Setter;
import io.jans.orm.reflect.util.ReflectHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DirectPropertyAccessor
implements PropertyAccessor {
    private static Field getField(Class<?> clazz, String name) throws PropertyNotFoundException {
        Field field;
        if (clazz == null || clazz == Object.class) {
            throw new PropertyNotFoundException("field not found: " + name);
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            field = DirectPropertyAccessor.getField(clazz, clazz.getSuperclass(), name);
        }
        if (!ReflectHelper.isPublic(clazz, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Field getField(Class<?> root, Class<?> clazz, String name) throws PropertyNotFoundException {
        Field field;
        if (clazz == null || clazz == Object.class) {
            throw new PropertyNotFoundException("field [" + name + "] not found on " + root.getName());
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            field = DirectPropertyAccessor.getField(root, clazz.getSuperclass(), name);
        }
        if (!ReflectHelper.isPublic(clazz, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    @Override
    public Getter getGetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        return new DirectGetter(DirectPropertyAccessor.getField(theClass, propertyName), theClass, propertyName);
    }

    @Override
    public Setter getSetter(Class<?> theClass, String propertyName) throws PropertyNotFoundException {
        return new DirectSetter(DirectPropertyAccessor.getField(theClass, propertyName), theClass, propertyName);
    }

    public static final class DirectSetter
    implements Setter {
        private static final long serialVersionUID = 7468445825009849335L;
        private final transient Field field;
        private final Class<?> clazz;
        private final String name;

        DirectSetter(Field field, Class<?> clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public void set(Object target, Object value) throws BasePersistenceException {
            try {
                this.field.set(target, value);
            }
            catch (Exception e) {
                if (value == null && this.field.getType().isPrimitive()) {
                    throw new PropertyAccessException(e, "Null value was assigned to a property of primitive type", true, this.clazz, this.name);
                }
                throw new PropertyAccessException(e, "could not set a field value by reflection", true, this.clazz, this.name);
            }
        }

        public String toString() {
            return "DirectSetter(" + this.clazz.getName() + '.' + this.name + ')';
        }

        Object readResolve() {
            return new DirectSetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }
    }

    public static final class DirectGetter
    implements Getter {
        private static final long serialVersionUID = 242538698307476168L;
        private final transient Field field;
        private final Class<?> clazz;
        private final String name;

        DirectGetter(Field field, Class<?> clazz, String name) {
            this.field = field;
            this.clazz = clazz;
            this.name = name;
        }

        @Override
        public Object get(Object target) throws BasePersistenceException {
            try {
                return this.field.get(target);
            }
            catch (Exception e) {
                throw new PropertyAccessException(e, "could not get a field value by reflection", false, this.clazz, this.name);
            }
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public Class<?> getReturnType() {
            return this.field.getType();
        }

        Object readResolve() {
            return new DirectGetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }

        public String toString() {
            return "DirectGetter(" + this.clazz.getName() + '.' + this.name + ')';
        }
    }
}

